<?php

$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

if (!empty($_POST['json'])) {
    $post = json_decode($_POST['json'], true);
}
if (empty($post)) {
    $post = array();
}

$cm = new ContentManager();
$cm->setTwigLoader($twig_loader);
$op = new PageOptions();
$admin_options = $op->getAdmin();

unset($admin_options['listing_container']);
unset($admin_options['template']);
unset($admin_options['allow_delete']);

if (!empty($post['more_recent_version_page_id'])) {
    ?>
    <div class="alert msg contentManagerEditPageAlert">
        <small>There is a more recent version of this page that is not yet been made current.
            <a  href="./?page=<?=$post['id']?>&history=<?=$post['more_recent_version_page_id']?>"
                title="Click here to edit it."
                data-page-id="<?=$post['id']?>"
                data-history-id="<?=$post['more_recent_version_page_id']?>"
                class="viewVersion"
            >
                Click here to edit it.
            </a>
        </small>
    </div>
    <?php
}
?>

<div class="pageActionBtns  clearfix">

    <?php

    if (
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_mtcadmin'] == true ||
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_mtcadmin'] == false && empty($post['lock']) && !empty($post['allow_update'])
    ) {
        ?>
        <div class="dialogueHint hint el"><i class="fa fa-info-circle"></i><div class="text">
            <?php
            if ( $_SESSION['content_manager']['is_mtcadmin'] == true ) {
                ?>
                <p>You are currently operating inside a page sandbox.</p>
                <?php
            }
            ?>
            <p><strong>To save these changes</strong> as a new version - click <strong>save</strong>.</p>
            <?php
            if ($_SESSION['content_manager']['is_mtcadmin'] == true || $_SESSION['content_manager']['is_publisher'] == true && empty($post['lock']) && !empty($post['allow_update'])) {
                ?>
                <p><strong>To make a page current</strong> - click <strong>make current</strong>.</p>
                <?php
            } else {
                ?>
                <p><strong>To make a page current</strong> - click <strong>request review</strong>. It will then need to be reviewed and made current by a publisher.</p>
                <?php
            }
            ?>
            <p><strong>To cancel any unsaved changes</strong> - click <strong>cancel</strong>.</p>
            <p><strong>To go to the current version of the page</strong> - click <strong>go to current</strong>.</p>
            <p><strong>Current</strong> version is the version that is visible by the public if page is public.</p>
        </div></div>
        <?php
    }
    if (
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_mtcadmin'] == true ||
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_publisher'] == true && empty($post['lock']) && !empty($post['allow_update'])
    ) {
        ?>
        <button class="btn greenBtn saveTriggerBtn">SAVE TRIGGER</button>
        <?php
    }
    if ($_SESSION['content_manager']['is_mtcadmin'] == true || $_SESSION['content_manager']['is_mtcadmin'] == false && empty($post['lock']) && !empty($post['allow_update'])) {
        ?>
        <button class="btn greenBtn savePageBtn">SAVE</button>
        <button class="btn blackBtn cancelUnsavedChangesBtn">CANCEL</button>
        <?php
        if ( defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true ) {
            ?>
            <button class="btn disabledBtn savedBtn">SAVED</button>
            <button class="btn greenBtn saveForReviewPageBtn">REQUEST REVIEW</button>
            <button class="btn disabledBtn pendingReviewBtn">PENDING REVIEW</button>
            <button class="btn currentBtn">CURRENT</button>
            <?php
        }
    }
    if (
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_mtcadmin'] == true ||
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_publisher'] == true && empty($post['lock']) && !empty($post['allow_update'])
    ) {
        ?>
        <button class="btn commitPageBtn">MAKE CURRENT</button>
        <button class="btn blackBtn declinePageBtn">DECLINE</button>
        <?php
    }
    if (
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_mtcadmin'] == true ||
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_mtcadmin'] == false && empty($post['lock']) && !empty($post['allow_update'])
    ) {
        ?>
        <button class="btn blackBtn goToCurrentPageBtn">GO TO CURRENT</button>
        <?php
    }
    if (
        $_SESSION['content_manager']['is_mtcadmin'] == true ||
        defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true && $_SESSION['content_manager']['is_publisher'] == true && $_SESSION['content_manager']['is_mtcadmin'] == false && empty($post['lock']) && !empty($post['allow_delete']) ||
        ( !defined("CMS_PAGE_VERSIONING") || CMS_PAGE_VERSIONING === false ) && $_SESSION['content_manager']['is_mtcadmin'] == false && empty($post['lock']) && !empty($post['allow_delete'])
    ) {
        ?>
        <button class="btn redBtn deletePageBtn">DELETE</button>
        <?php
    }

    if ( $_SESSION['content_manager']['is_mtcadmin'] ) {
        ?>

        <button class="btn newPageBtn">NEW PAGE</button>

        <fieldset class="topBarButtonFieldset pageFieldset">
            <?php
            if (
                defined("CMS_PAGE_PREVIEW") && CMS_PAGE_PREVIEW === true &&
                empty($post['lock']) && !empty($post['allow_update']) &&
                ( empty($post['published']) || CMS_PAGE_PREVIEW_ADV === true )
            ) {
                $adv = "";
                if ( CMS_PAGE_PREVIEW_ADV === true ) {
                    $adv = "adv-";
                }
                ?>
                <a href="#" class="page-<?=$adv?>preview-btn preview-page-btn" title="Preview page">
                    <i class="fa fa-eye"></i>
                </a>
                <a href="#" class="hidden-preview-page-btn" style="display:none">&nbsp;</a>
                <?php
            }
            ?>
            <a href="#" class="page-copy-btn copy-page-btn" title="Copy page(s)">
                <i class="fa fa-copy"></i>
            </a>
            <a href="#" class="paste-page-btn" title="Paste page(s)">
                <i class="fa fa-paste"></i>
            </a>
            <a href="#" class="create-trigger-btn" title="Create Trigger">
                <i class="fa fa-plus-square"></i>
            </a>
            <?php
            if (defined('CMS_ALLOW_CLIENTS_TO_SWITCH_TEMPLATES') && CMS_ALLOW_CLIENTS_TO_SWITCH_TEMPLATES === true) {
                ?>
                <a href="#" class="set-allowed-templates-for-switching-btn" title="Set what templates client is allowed to switch between in this page.">
                    <i class="fa fa-server"></i>
                </a>
                <?php
            }
            ?>
        </fieldset>

        <fieldset class="topBarButtonFieldset pagedataFieldset">
            <span class="pagedataFieldsetLabel topBarButtonFieldsetLabel">Pagedata</span>
            <a href="#" class="add-page-pagedata-btn" title="Add a pagedata field">
                <i class="fa fa-plus-circle"></i>
                <div id="pagedataTypes" class="hidden" data-types='<?=json_encode(ContentManager::$pagedata_types)?>'></div>
            </a>
            <a href="#" class="pagedata-copy-btn copy-page-pagedata-btn" title="Copy all a pagedata fields on this page">
                <i class="fa fa-copy"></i>
            </a>
            <a href="#" class="paste-page-pagedata-btn" title="Paste pagedata fields into this page">
                <i class="fa fa-paste"></i>
            </a>
            <a
                href="#"
                class="storePagedataStructureInTheTemplateBtn tooltip <?=(isset($post['is_structure_saved']) && $post['is_structure_saved'] == false ? 'structureIsNotSaved' : 'structureIsSaved')?>"
                title="Store pagedata structure in the template. Allowing new pages to load fields directly from and for the template. If this is light blue it means current page structure isn't stored."
            >
                <i class="fa fa-suitcase"></i>
            </a>

            <a href="#" class="loadPagedataStructureFromTheTemplateBtn tooltip" title="Load pagedata structure from the template.">
                <i class="fa fa-newspaper-o"></i>
            </a>
        </fieldset>

        <?php
    } else {
        if (defined("CMS_PAGE_PREVIEW") && CMS_PAGE_PREVIEW === true && empty($post['lock']) && !empty($post['allow_update']) &&
            (empty($post['published']) || CMS_PAGE_PREVIEW_ADV === true)) {
            $adv = "";
            if (CMS_PAGE_PREVIEW_ADV === true) {
                $adv = "adv-";
            }
            ?>
            <fieldset class="topBarButtonFieldset pageFieldset">
                <a href="#" class="page-<?=$adv?>preview-btn preview-page-btn" title="Preview page">
                    <i class="fa fa-eye"></i>
                    PREVIEW
                </a>
                <a href="#" class="hidden-preview-page-btn" style="display:none">&nbsp;</a>
            </fieldset>

            <?php
        }
    }

    if ( defined('CMS_MULTI_LANG') && CMS_MULTI_LANG === true ) {
        ?>
        <fieldset class="topBarButtonFieldset languageSelectFieldset">
            <select name="language" class="languageSelect mtcBlue">
                <?php
                foreach (Language::where('active',1)->orderBy("order")->get() as $language) {
                    echo '<option
                        value="'.($language->default == 1 ? '' : $language->code).'"
                        '.(!empty($_SESSION['content_manager']['language']) && $_SESSION['content_manager']['language'] == $language->code ? 'selected' : '').'
                    >'.strtoupper($language->{CMS_MULTI_SWITCH_LABEL}).'</option>';
                }
                ?>
            </select>
        </fieldset>
        <?php
    }
    ?>

    <fieldset class="topBarButtonFieldset alertFieldset">
        <a href="#header" title="Alerts" class="goToAlert">
            <i class="fa fa-exclamation-triangle" aria-hidden="true"></i>
        </a>
    </fieldset>

    <div class="controlPanelLoaderContainerInActionBtns">
        <div id="controlPanelLoader" class="controlPanelLoader">
            <span class="spinnerContainer">
              <span class="spinner"></span>
            </span>
            <span class="loaderMessage">loading...</span>
        </div>
    </div>

</div>

<form method="post" action="" class="mainForm" enctype="multipart/form-data">

    <div class="styleBox">

        <?php include("edit_page_basics.php"); ?>

        <?php
        if ( $_SESSION['content_manager']['is_mtcadmin'] || CMS_ALLOW_CLIENT_TO_EDIT_SEO === true ) {
            include("edit_page_seo.php");
        }
        ?>

        <?php
        if ($_SESSION['content_manager']['is_mtcadmin'] == true || $_SESSION['content_manager']['is_mtcadmin'] == false && empty($post['lock'])) {
            include("edit_page_settings.php");
            include("edit_page_pagedata.php");
        }
        ?>

    </div>

</form>
