<?php

use Mtc\Cms\Models\PageOption;

/**
 * PAGE OPTIONS CLASS
 * Class adding more flexibility for working with page options. At current
 * stage class allows toggle admin only page options.
 *
 * @copyright MTC media Ltd
 * @author Jared Denysov <jared.denysov@mtcmedia.co.uk>
 * @version 1.0
 *
 */
Class PageOptions
{

    /**
     * Update option is_admin by given key
     *
     * @param $key
     * @param $value
     * @return void
     */
    public static function updateAdminByKey( $key, $value ): void
    {
        PageOption::query()
            ->where('key', $key)
            ->update([
                'is_admin' => $value,
            ]);
    }

    /**
     * Retrieves all page options and maps them into an associative array where the keys
     * are the option keys and the values indicate whether the option is admin-related.
     *
     * @return array An associative array of page options with their admin status.
     */
    public static function getAdmin(): array
    {
        return PageOption::all()
            ->mapWithKeys(function ($item) {
                return [$item->key => $item->is_admin];
            })
            ->toArray();
    }
}