<?php

namespace Mtc\Cms\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Node extends Model
{
    use SoftDeletes;

    protected $table = 'nodes';

    protected $fillable = [
        'url',
        'title',
        'description',
        'status',
        'visibility',
        'nodeable_type',
        'nodeable_id',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];
    public function nodeable()
    {
        return $this->morphTo();
    }

    /**
     * Check if URL already exists
     *
     * @param $url
     * @return bool
     */
    public static function urlExists($url)
    {
        return self::query()
            ->where('url', $url)
            ->exists();
    }

}
