<?php

$path = '../../../';
require $path.'core/includes/header.inc.php';

use MTC\Core\SeoCanonical as SeoCanonical;

$page_meta['title'] = 'Manage SEO Canonical URLs';

$errors = array();
$form = new SeoCanonical;

if ($_REQUEST['delete']) {
    SeoCanonical::destroy($_REQUEST['delete']);
    header('Location: manage.seo.canonicals.php?message=success');
    exit();
}

if ($_REQUEST['edit']) {
    $form = SeoCanonical::find($_REQUEST['edit']);
}

if ($_REQUEST['action'] == 'update') {
    $form->path = $_REQUEST['path'];
    $form->canonical_path = $_REQUEST['canonical_path'];

    if (!preg_match('#^/#', $_REQUEST['path'])) {
        $errors[] = 'Your path has to start with a forward slash: /';
    }

    if ($_REQUEST['path'] == '/') {
        $errors[] = 'Use /index.php for home';
    }

    if (count($errors) === 0) {
        SeoCanonical::unguard();
        SeoCanonical::updateOrCreate(array(
            'path' => $_REQUEST['path'],
        ), array(
            'canonical_path' => $_REQUEST['canonical_path'],
        ));
        SeoCanonical::reguard();

        header('Location: manage.seo.canonicals.php?message=success');
        exit;
    }
}

if ($_REQUEST['action'] == 'csv') {
    if (!empty($_REQUEST['export'])) {
        header('Location: csv.get.php?type=paths');
        exit();
    } elseif (!empty($_REQUEST['import'])) {
        SeoCsv::importCsv('paths');
        header('Location: manage.seo.canonicals.php?message=success');
        exit;
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/admin/seoadmin">Manage SEO</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>SEO Canonical URLs</h1>
<?php
include 'tabnav.php';

if (count($errors) > 0) {
    showerrors($errors);
}
if (count($errors) == 0 && $_REQUEST['message'] == 'success') {
    echo showmsg("Operation carried out successfully", "success", $path);
}

// include __DIR__.'/templates/csvform.html.php';
?>

<form action="<?= $_SERVER['PHP_SELF']; ?>" method="post" class="style">
    <fieldset>
        <?php
        if (!$_REQUEST['edit']) {
            ?>
            <h1><a class="show el">Add Rule<i class="fa fa-caret-right"></i></a></h1>
            <?php

        }
        ?>
        <div class="row">
            <label for="path">Path</label>
            <?php
            if (!$_REQUEST['edit']) {
                ?>
                <input type="text" name="path" id="path" value="<?= clean_page($form->path); ?>">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div class="text">
                        <h1>Page Path</h1>
                        <p>
                            Beginning of link to the page you want to set canonical path data for starting with the / after .co.uk or .com etc
                            <br />Use /index.php for the homepage
                        </p>
                    </div>
                </div>
                <?php

            } else {
                echo clean_page($form->path);
                ?>
                <input type="hidden" name="path" value="<?= clean_page($form->path); ?>" />
                <?php

            }
            ?>
        </div>
        <div class="row">
            <label for="canonical_path">Canonical Path</label>
            <input type="text" name="canonical_path" id="canonical_path" value="<?= clean_page($form->canonical_path); ?>">
            <div class="hint el">
                <i class="fa fa-info-circle"></i>
                <div class="text">
                    <h1>Canonical Path</h1>
                    <p>
                        Beginning of canonical path starting with the / after .co.uk or .com etc
                    </p>
                </div>
            </div>
        </div>
        <input type="hidden" name="action" value="update">
        <input type="submit" class="btn" value="Set Rule"/>
        <?php
        if ($_REQUEST['edit']) {
            ?>
            <input type="hidden" name="edit" value="<?= clean_page($_REQUEST['edit']); ?>">
            <?php

        }
        if (! $_REQUEST['edit']) { ?>
            <div class="search-button"><input type="submit" value="Add" class="BUTTON"/></div>
        <?php } else { ?>
            <div class="search-button"><input type="submit" value="Edit" class="BUTTON"/></div>
        <?php } ?>
    </fieldset>
</form>

<?php
$canonicals = SeoCanonical::all()->keyBy('path');

if (! $_REQUEST['edit'] && $canonicals->count() > 0) {
    ?>
    <table class="">
        <tr>
            <th class="center"></th>
            <th>Path</th>
            <th>Canonical Path</th>
            <th class="center"></th>
        </tr>
        <tbody class="tabular ui-sortable">
            <?php
            foreach ($canonicals as $page) {
                ?>
                <tr>
                    <td>
                        <a href="<?= clean_page($page['path']); ?>" target="_blank"><i class="fa fa-eye"></i></a>
                    </td>
                    <td><?= clean_page($page['path']); ?></td>
                    <td><?= clean_page($page['canonical_path']); ?></td>
                    <td>
                        <a href="?edit=<?= $page['id']; ?>"><i class="fa fa-pencil"></i></a>
                        &nbsp;
                        <a href="?delete=<?= $page['id']; ?>" class="alert error" title="Are you sure you want to delete this seo entry?"><i class="fa fa-times-circle"></i></a>
                    </td>
                </tr>
                <?php

            }
    ?>
        </tbody>
    </table>

    <?php

}
require_once $path . 'core/admin/templates/adminfooter.html.php';
