<ul class="breadcrumbs el">
	<li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1><?= clean_page($page_meta['title']) ?></h1>

<ul class="tabnav el">
    <?php
    foreach ($environments as $environment) {
        $params['environment'] = $environment;
        $label = ucfirst($environment);

        $selected = '';
        if ($environment == $_REQUEST['environment'] || (empty($environment) && empty($_REQUEST['environment']))) {
            $selected = "class='selected'";
        }

        if (empty($label)) {
            $label = 'Default';
        }
        ?>
        <li <?=$selected?>>
            <a href="?<?=http_build_query($params)?>"><?=clean_page($label)?></a>
        </li>
        <?php
    }
    ?>
</ul>

<?php
if (is_array($errors) && !empty($errors)) {
    showerrors($errors);
} elseif (isset($_POST['settings']) && is_array($_POST['settings']) || isset($_POST['action'])) {
    echo showmsg("Settings updated at " . date('c'), 'success', $path);
}
if (!empty($message)) {
    echo showmsg($message, 'success', $path);
}
if (config('app.env') === 'staging') {
    ?>
    <form action="/core/admin/settings/"
          class="style"
          method="POST">
        <fieldset class="show">
            <h1 class="show">
                Add new Setting
            </h1>

            <div class="row">
                <label for="module">
                    Module
                </label>
                <input type="text"
                       name="module"
                       value="<?= clean_page(filter_input(INPUT_POST, 'module')) ?>"
                       id="module"/>
            </div>
            <div class="row">
                <label for="type">
                    Type
                </label>
                <select name="type"
                        id="type">
                    <option value="bool"
                        <?= filter_input(INPUT_POST, 'type') === 'bool' ? 'selected' : '' ?>>
                        Boolean
                    </option>
                    <option value="int"
                        <?= filter_input(INPUT_POST, 'type') === 'int' ? 'selected' : '' ?>>
                        Integer
                    </option>
                    <option value="float"
                        <?= filter_input(INPUT_POST, 'type') === 'float' ? 'selected' : '' ?>>
                        Float
                    </option>
                    <option value="string"
                        <?= filter_input(INPUT_POST, 'type') === 'string' ? 'selected' : '' ?>>
                        String
                    </option>
                </select>
            </div>
            <div class="row">
                <label for="key">
                    Key
                </label>
                <input type="text"
                       name="key"
                       value="<?= clean_page(filter_input(INPUT_POST, 'key')) ?>"
                       id="key"/>
            </div>
            <div class="row">
                <label for="value">
                    Value
                </label>
                <input type="text"
                       name="value"
                       value="<?= clean_page(filter_input(INPUT_POST, 'value')) ?>"
                       id="value"/>
            </div>
            <div class="row">
                <label for="description">
                    Description
                </label>
                <input type="text"
                       name="description"
                       value="<?= clean_page(filter_input(INPUT_POST, 'description')) ?>"
                       id="description"/>
            </div>

            <div class="row">
                <input type="hidden"
                       name="action"
                       value="add_new"/>
                <button type="submit"
                        class="btn">
                    Add
                </button>
            </div>
        </fieldset>
    </form>
    <?php
}
?>

<form method="post" action="">

    <div class="settingsStickyRowWrap js_settingsStickyRowWrap">
        <div class="settingsStickyRow">
            <div class="settingsFixed">
                <input type="submit" value="Save" />
                <span class="settingsFixedTitle"><?= clean_page($page_meta['title']) ?></span>
            </div>
        </div>
    </div>

    <?php
    foreach ($data as $module => $settings) {
        ?>
        <div class="row">
        <table class="manage-items">
            <thead>
            <tr>
                <th>Module</th>
                <th>Key</th>
                <th width="1">Type</th>
                <th>Value</th>
                <th width="1">Updated At</th>
            </tr>
            </thead>
            <tbody class="tabular">
            <?php
            foreach ($settings as $setting) {
                require __DIR__ . '/index.field.tpl.php';
            }
            ?>
            </tbody>
        </table>
        <?php
    }
    ?>

    <input type="hidden" name="action" value="save" />
    <input type="hidden" name="environment" value="<?= clean_page($_REQUEST['environment']) ?>" />

</form>
