<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Mtc\Modules\Members\Models\Member;
use Mtc\Shop\Assessment\Assessment;
use Mtc\Shop\Order;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class OrderInfoFactory extends Factory
{
    protected $model = \Mtc\Shop\Order\Info::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $dob = fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d');

        return [
            'order_id' => Order::factory(),
            'message' => '',
            'newsletter' => 1,
            'how_did_you_hear_about_us' => '',
            'how_did_you_hear_about_us_text' => '',
            'timestamp' => now(),
            'phone_prefix' => '+44',
            'assessment_ids' => Assessment::all()->pluck('id'),
            'multisite__site_id' => 1,
        ];
    }

    public function cutomer_details(Member $member)
    {
        return $this->state(function (array $attributes) use ($member) {
            return [
                'member_conditions' => json_encode($member->getConditionsArray()),
                'member_medications' => json_encode($member->getMedicationsArray()),
                'member_allergies' => json_encode($member->getAllergiesArray()),
                'email' => $member->email,
                'email_hash' => Hash::make($member->email),
                'contact_no' => $member->contact_no,
                'contact_no_hash' => Hash::make($member->contact_no),
                'dob' => $member->getDob(),
                'dob_hash' => Hash::make($member->getDob()),
            ];
        });
    }
}
