<?php

use App\Src\Encryption;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('order_info', function (Blueprint $table) {
            $table->text('email')->change();
            $table->text('contact_no')->change();
            $table->text('dob')->nullable()->after('dob_date');
            $table->dropColumn('dob_date');
            $table->dropColumn('dob_month');
            $table->dropColumn('dob_year');
        });
        Schema::table('patient_files', function (Blueprint $table) {
            $table->text('name')->change();
            $table->text('full_name')->change();
            $table->text('path')->change();
        });
        Schema::table('wisebee_documents', function (Blueprint $table) {
            $table->text('title')->change();
        });
        Schema::table('members', function (Blueprint $table) {

            $table->dropUnique('members_email_index');
            $table->dropIndex('members_email_unique');
            $table->text('email')->change();
            $table->text('contact_no')->change();
            $table->text('dob')->nullable()->after('dob_date');
            $table->dropColumn('dob_date');
            $table->dropColumn('dob_month');
            $table->dropColumn('dob_year');
        });
        Schema::table('members_addresses', function (Blueprint $table) {
            $table->text('firstname')->nullable()->change();
            $table->text('middle_name')->nullable()->change();
            $table->text('lastname')->nullable()->change();
            $table->text('address1')->nullable()->change();
            $table->text('address2')->nullable()->change();
            $table->text('city')->nullable()->change();
            $table->text('postcode')->nullable()->change();
        });
        Schema::table('nhs_members', function (Blueprint $table) {
            $table->text('job_title')->nullable()->change();
            $table->text('firstname')->nullable()->change();
            $table->text('lastname')->nullable()->change();
            $table->text('dob')->nullable()->change();
            $table->text('nhs_number')->nullable()->change();
        });
        Schema::table('wisebee_participants', function (Blueprint $table) {
            $table->text('email')->nullable()->change();
            $table->text('firstname')->nullable()->change();
            $table->text('lastname')->nullable()->change();
            $table->text('notes')->nullable()->change();
        });
        Schema::table('basket_address', function (Blueprint $table) {
            $table->text('firstname')->nullable()->change();
            $table->text('middle_name')->nullable()->change();
            $table->text('lastname')->nullable()->change();
            $table->text('address1')->nullable()->change();
            $table->text('address2')->nullable()->change();
            $table->text('city')->nullable()->change();
            $table->text('postcode')->nullable()->change();
        });
        Schema::table('basket_info', function (Blueprint $table) {
            $table->text('email')->nullable()->change();
            $table->text('contact_no')->nullable()->change();
            $table->text('dob')->nullable()->after('dob_date');
            $table->dropColumn('dob_date');
            $table->dropColumn('dob_month');
            $table->dropColumn('dob_year');
        });
        Schema::table('black_list', function (Blueprint $table) {
            $table->text('email')->nullable()->change();
            $table->text('telephone')->nullable()->change();
        });
        Schema::table('emails_double_optin', function (Blueprint $table) {
            $table->text('email')->change();
            $table->text('firstname')->change();
            $table->text('surname')->nullable()->change();
        });
        Schema::table('emails_lists_mails', function (Blueprint $table) {
            $table->dropIndex('email');
            $table->text('email')->change();
            $table->text('firstname')->change();
            $table->text('surname')->nullable()->change();
        });
        Schema::table('emails_queued', function (Blueprint $table) {
            $table->text('email')->change();
        });
        Schema::table('event_log', function (Blueprint $table) {
            $table->dropIndex('event_log_ip_address_index');
            $table->text('ip_address')->change();
        });
        Schema::table('order_contact', function (Blueprint $table) {
            $table->text('subject')->nullable()->change();
        });
        Schema::table('order_address', function (Blueprint $table) {
            $table->text('firstname')->nullable()->change();
            $table->text('middle_name')->nullable()->change();
            $table->text('lastname')->nullable()->change();
            $table->text('address1')->nullable()->change();
            $table->text('address2')->nullable()->change();
            $table->text('city')->nullable()->change();
            $table->text('postcode')->nullable()->change();
        });
        Schema::table('order', function (Blueprint $table) {
            $table->integer('delivery_method_id')->nullable()->change();
        });
        Schema::table('admin_users', function (Blueprint $table) {
            $table->dropIndex('email');
            $table->dropIndex('username');
            $table->text('email')->change();
            $table->text('name')->change();
            $table->text('username')->change();
        });
        Schema::table('forms', function (Blueprint $table) {
            $table->text('email_receiver')->change();
        });

        foreach (Encryption::$modelsWithEncryption as $modelName) {
            $model = new $modelName;
            $tableName = $model->getTable();
            if (empty($model::$searchable)) {
                continue;
            }

            Schema::table($tableName, function (Blueprint $table) use ($model, $tableName) {
                foreach ($model::$searchable as $field) {
                    if (Schema::hasColumn($tableName, $field . '_hash')) {
                        continue;
                    }
                    $table->string($field . '_hash')->after($field)->nullable()->index();
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        // No revert, breaking changes
    }
};