<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rate_limits', function (Blueprint $table) {
            // Add composite index for common query pattern (key + ip + created_at)
            $table->index(['key', 'ip_address', 'created_at'], 'rate_limits_lookup_index');
            
            // Add index for cleanup queries
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rate_limits', function (Blueprint $table) {
            $table->dropIndex('rate_limits_lookup_index');
            $table->dropIndex(['created_at']);
        });
    }
};
