<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Mtc\Plugins\Agent\database\seeders\AgentSettingsSeeder;
use Mtc\Plugins\Agent\database\seeders\StepsOutputBackgroundSeeder;

class DatabaseSeeder extends Seeder
{
    public function run() : void
    {
        // 0) Seed admin users
        $this->call([
            AdminUsersTableSeeder::class,
        ]);

        // 1) Foundation / reference data (no FKs to app data)
        $this->call([
            LanguagesTableSeeder::class,
            CountriesTableSeeder::class,
            CountryStatesTableSeeder::class,
            CurrenciesTableSeeder::class,
            VatTableSeeder::class,
            SubscriptionPreferencesTableSeeder::class,
            SeoSettingsTableSeeder::class,
            SeoDefaultsTableSeeder::class,
            PlaceholderImagesTableSeeder::class,
            ShareButtonsTableSeeder::class,
            AgentSettingsSeeder::class,
            StepsOutputBackgroundSeeder::class,
        ]);

        // 2) Domain reference that others depend on
        $this->call([
            DoctorSurgeriesTableSeeder::class,
            PropertyTypesTableSeeder::class,
            PropertiesTableSeeder::class,
            AdminMenuTableSeeder::class,
            AdminRolesTableSeeder::class,
            AdminRolePermissionsTableSeeder::class,
            DeliveryZonesTableSeeder::class,
            DeliveryMethodsTableSeeder::class,
            DeliveryServicesOptionsTableSeeder::class,
            DeliveryMethodRatesTableSeeder::class,
            MedicalConditionsTableSeeder::class,
            IngredientsTableSeeder::class,
            ActiveSubstancesTableSeeder::class,
            PagesTableSeeder::class,
            PageOptionsTableSeeder::class,
            SiteMenuTableSeeder::class,
            StaticBlocksTableSeeder::class,
            StaticBlocksInstancesTableSeeder::class,
            StaticBlocksSizesTableSeeder::class,
            PageListTableSeeder::class,
            PageListItemTableSeeder::class,
            PageListItemDataTableSeeder::class,
        ]);

        // 3) Items (may depend on previous refs)
        $this->call([
            ItemsTableSeeder::class,
            ItemsInfoTableSeeder::class,
            ItemsBrandsTableSeeder::class,
            ItemsCategoriesTableSeeder::class,
            ItemsSizesTableSeeder::class,
            ItemsSizesCustomTableSeeder::class,
            ItemsCustomTableSeeder::class,
            ItemsImagesTableSeeder::class,
            IncompatibleMedicationsTableSeeder::class,
            CategoriesTableSeeder::class,
            CategoryRestrictedZonesTableSeeder::class,
        ]);

        // 4) Custom Fields (after items/categories if needed)
        $this->call([
            CustomFieldsSetsTableSeeder::class,
            CustomFieldsTableSeeder::class,
            CustomFieldsSetsFieldsTableSeeder::class,
        ]);

        // 5) Assessments (group these once; remove duplicates)
        $this->call([
            AssessmentFormsTableSeeder::class,
            AssessmentQuestionsTableSeeder::class,
            AssessmentsTableSeeder::class,
            AssessmentAnswersTableSeeder::class,
            AssessmentAnswersMagentoTableSeeder::class,
            AssessmentQualifyingAnswersTableSeeder::class,
            AssessmentQualifyingAnswersGroupsTableSeeder::class,
            AssessmentQualifyingAnswersGroupsConfigTableSeeder::class,
            AssessmentQualifyingAnswersGroupTemplatesTableSeeder::class,
        ]);

        // 6) Multisite (if other entities need to exist first)
        $this->call([
            MultisiteBaseEntitiesTableSeeder::class,
        ]);

        // 7) Local-only heavy data last (so devs can skip/target easily)
        if (app()->environment('local')) {
            $this->call([
                MembersTableSeeder::class,
                OrderTableSeeder::class,
                OrderStripeTableSeeder::class,
            ]);
        }
    }

    /**
     * Optional: truncate a curated list of tables in the correct order.
     * Call this manually if/when you need a clean slate.
     */
    protected function truncateTables(array $tables): void
    {
        Schema::disableForeignKeyConstraints();
        foreach ($tables as $table) {
            DB::table($table)->truncate(); // resets AUTO_INCREMENT
        }
        Schema::enableForeignKeyConstraints();
    }
}
