<?php
$path = "{{{PATH_TO_ROOT}}}";
require_once $path . 'core/includes/header.inc.php';
require_once 'includes/settings.php'; // MODEL SETTINGS

if (empty($_GET['id']) || !is_numeric($_GET['id']) || empty($_GET['attr_name'])) {
    die("malformed request!");
}

$attr_name = $_GET['attr_name'];

if (empty($_GET['relation_key']) || !preg_match("/^[a-zA-Z_]+$/", $_GET['relation_key'])) {
    $model_class_name = MODEL_CLASS_NAMESPACE_PREFIX . MODEL_CLASS_NAME;
    $crop_adjust = $model_form[$attr_name]['crop_adjust'];
} else {
    $model_class_name = $module['relations'][$_GET['relation_key']]['class_name'];
    $crop_adjust = $module['relations'][$_GET['relation_key']]['form'][$attr_name]['crop_adjust'];
}

$module['object'] = $model_class_name::find($_GET['id']);
unset($_GET['id']);

if (empty($module['object'])) {
    die("Unable to find object!");
}

$filename = $module['object']->{$attr_name};
if (empty($filename)) {
    die("no image found");
}

$page_meta['title'] = 'Edit Page > Crop Adjust';

if (!isset($crop_adjust)) {
    die("This image doesn't have crop adjust setup!");
}

// Get first crop adust size
$image_cms_images_size = $crop_adjust[0];
// Check if other is selected via post select box
if (isset($_POST['image_cms_images_size'])) {
    for ($i=0; $i < count($crop_adjust); $i++) {
        if ($crop_adjust[$i] == $_POST['image_cms_images_size']) {
            $image_cms_images_size = $_POST['image_cms_images_size'];
        }
    }
}

// ON POST
if (isset($_POST['submitBtn'])) {

    // get selected size params
    $resize = $image_folders['cms_images'][$image_cms_images_size];
    // refresh image unique name by removing old time() prepend and adding a new one
    $new_filename = CropAdjust::refreshImageUniqueName($filename);
    // raname current images with new name of there are no caching issues
    CropAdjust::renameAllImageSizes($image_folders['cms_images'], $filename, $new_filename);
    // save new image name
    $module['object']->{$attr_name} = $new_filename;
    $module['object']->save();

    // if the a specific crop area is selected
    if (!empty($_POST['jcropX']) || !empty($_POST['jcropY']) || !empty($_POST['jcropW']) || !empty($_POST['jcropH'])) {
        // crop via settings
        CropAdjust::recrop(
            $new_filename,                                    // new image filename
            $image_folders['cms_images']['original']['path'], // path from where to take an uncropped original
            $resize,                                          // selected size params that the image needs to follow (width, height, path)
            $_POST['jcropW'],
            $_POST['jcropH'],
            $_POST['jcropX'],
            $_POST['jcropY']
        );
    } else {
        // resize via usual settings if crop area isn't selected
        k_resize_image(
            SITE_PATH . "/" . $image_folders['cms_images']['original']['path'] . "/" . $new_filename,
            SITE_PATH . "/" . $resize['path'] . "/" . $new_filename,
            $resize['width'],
            $resize['height'],
            $resize['crop'],
            0,
            $resize['quality'],
            $resize['crop_position']
        );
    }
    $filename = $new_filename;
}

$original_size = get_image_size($image_folders['cms_images']['original']['path'], $filename);

include($path . 'core/admin/templates/adminheader.full.php');

?>

<!-- MODULE CSS FILES -->
<link rel="stylesheet" href="css/style.css" />
<!-- end of MODULE CSS FILES -->

<div id="cropAdjust">
    <h1>Crop Adjust</h1>
    <p>To adjust how the image is cropped you can click and drag over then original
    image, select the perfect crop location - then press 'Crop'. To revert to default
    crop state: don't draw the crop square and press crop.</p>

    <form action="" method="POST" class="el miniselector">
        <fieldset>
            <?php

            if (count($crop_adjust) > 1) {
                ?>
                <div class="row" >
                    <label for="image_cms_images_size">Size:</label>
                    <select
                        id="image_cms_images_size"
                        name="image_cms_images_size"
                    >
                        <?php
                        for ($i=0; $i < count($crop_adjust); $i++) {
                            ?>
                            <option
                                value="<?= clean_page($crop_adjust[$i]) ?>"
                                <?=($image_cms_images_size == $crop_adjust[$i] ? "selected" : "")?>
                            >
                                <?= clean_page($crop_adjust[$i]) ?>
                            </option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <?php
            }
            ?>

            <div class="original form-box">
                <h2>Original</h2>
                <div class="container">
                    <img
                        src="/<?= clean_page($image_folders['cms_images']['original']['path']) ?>/<?= clean_page($filename) ?>"
                        id="mbCropAdjust"
                        alt="recrop"
                        style="width: <?= clean_page($original_size['width']) ?>px; max-width: <?= clean_page($original_size['width']) ?>px;"
                    />
                </div>
            </div>

            <div class="result form-box">
                <h2>Result</h2>
                <img
                    id="result-image"
                    data-filename="<?=$filename?>"
                    src="/<?= clean_page($image_folders['cms_images'][$image_cms_images_size]['path']) ?>/<?= clean_page($filename) ?>"
                    class="resultImage"
                />
            </div>

            <div class="btn-section">
                <input type="submit" class="button submit" name="submitBtn" value="Crop" id="cropButton" />
                <input
                    type="button"
                    class="button submit closeFancybox"
                    name="submitBtn"
                    value="Close"
                    id="btn_cancel"
                />
            </div>

            <input
                type="hidden"
                id="aspectratio"
                value="<?=($image_folders['cms_images'][$image_cms_images_size]['width'] / $image_folders['cms_images'][$image_cms_images_size]['height'])?>"
            />
            <input type="hidden" id="minwidth" value="0" />
            <input type="hidden" id="minheight" value="0" />
            <input
                type="hidden"
                name="image"
                value="/<?= clean_page($image_folders['cms_images']['original']['path']) ?>/<?= clean_page($filename) ?>"
            />
            <input type="hidden" name="filename" value="<?= clean_page($filename) ?>" />
            <input type="hidden" name="jcropX" id="jcropX" value="0" />
            <input type="hidden" name="jcropY" id="jcropY" value="0" />
            <input type="hidden" name="jcropW" id="jcropW" value="0" />
            <input type="hidden" name="jcropH" id="jcropH" value="0" />

        </fieldset>
    </form>
</div>
<?php
include($path . 'core/admin/templates/adminfooter.full.php');
