<?php

namespace Mtc\Plugins\Agent\Agents\Observers;

use Mtc\Plugins\Agent\Http\Controllers\TokenUsageController;
use NeuronAI\Observability\Events\InferenceStop;
use SplSubject;

class TokenUsageObserver implements \SplObserver
{
    public function update(SplSubject $subject, string $event = "*", mixed $data = null): void
    {
        if ($event === 'inference-stop' && $data instanceof InferenceStop) {
            $usage = $data->response->getUsage();

            if ($usage) {
                $inputTokens = $usage->inputTokens;
                $outputTokens = $usage->outputTokens;
                $date = date('Y-m-d');

                $controller = new TokenUsageController();

                $controller->updateTokens($inputTokens, $outputTokens, $date);
            }
        }
    }
}
