<?php

namespace Mtc\Plugins\Agent\Agents\Outputs;

use NeuronAI\StructuredOutput\SchemaProperty;

class ProductOutput
{
    // The product name extracted from the customer's message
    #[SchemaProperty(
        description: 'The name of the medication or product the customer is asking about.',
        required: true
    )]
    public string $name;

    // product id
    #[SchemaProperty(
        description: 'The unique identifier of the product in the database. Also known as product ID.',
        required: true
    )]
    public int $productId;

    // The friendly, professional chat response to the customer
    #[SchemaProperty(
        description: 'The final, friendly response to the customer, based on the instructions. This is the main conversational output.',
        required: true
    )]
    public string $response;

    // You can add other properties, e.g., for safety flags
    #[SchemaProperty(
        description: 'A boolean indicating if the query is a request for medical advice.',
        required: false
    )]
    public bool $isMedicalAdvice = false;
}
