<?php

namespace Mtc\Plugins\Agent\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class ChatGenerated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public string $message;
    public ?string $productName;
    public $productId;
    public $item;
    public string $guestId;
    private string $channelName;

    public function __construct(string $message, string $productName, $productId, $item, string $guestId)
    {
        $this->message = $message;
        $this->productName = $productName;
        $this->productId = $productId;
        $this->item = $item;
        $this->guestId = $guestId;
        $this->channelName = 'agent-channel.' . $this->guestId;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        Log::info("Broadcasting ChatGenerated event with message: " . $this->message);
        // This is a Public Channel, meaning anyone can listen.
        return [
            new PrivateChannel($this->channelName),
        ];
    }

    /**
     * The name of the broadcast event.
     *
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'new.notification';
    }
    public function broadcastWith(): array
    {
        Log::info("Broadcasting data: message=" . $this->message . ", productName=" . $this->productName . ", productId=" . $this->productId);
        return [
            'status' => 'success',
            'message' =>$this->message,
            'productName' =>$this->productName,
            'productId' =>$this->productId,
            'item' =>$this->item,
        ];
    }

}
