<?php

namespace Mtc\Plugins\Agent\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class Thinking implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */

    public string $guestId;
    private string $channelName;

    public function __construct(string $guestId)
    {
        $this->guestId = $guestId;
        $this->channelName = 'agent-channel.' . $this->guestId;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        Log::info("Broadcasting Thinking event with guest id: " . $this->guestId);
        // This is a Public Channel, meaning anyone can listen.
        return [
            new PrivateChannel($this->channelName),
        ];
    }

    /**
     * The name of the broadcast event.
     *
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'new.progress';
    }
    public function broadcastWith(): array
    {
        Log::info("Broadcasting Thinking event with guest id: " . $this->guestId);
        return [
            'status' => 'thinking',
        ];
    }

}
