<?php

namespace Mtc\Plugins\Agent\Http\Controllers;
use Illuminate\Routing\Controller;
use Mtc\Core\Admin\Menu;

class AdminController extends Controller
{
    public static function injectAdminMenuItems(): void
    {
        $title = 'AI Agent';
        if (Menu::query()->where('title', $title)->exists()) {
            return;
        }

        $AIAgentMenu = Menu::query()
                           ->create([
                               'sub_id' => '0',
                               'title' => $title,
                               'icon' => 'fa fa-superpowers',
                               'order' => '1',
                           ]);

        $subItems = [
            [
                'sub_id' => $AIAgentMenu->id,
                'title' => 'Dashboard',
                'path' => '/plugins/Agent/admin/',
                'activePath' => '/plugins/Agent/admin/',
                'icon' => 'fa fa-tachometer-alt',
                'order' => '1',
            ],
        ];

        foreach ($subItems as $subItem) {
            Menu::query()
                ->create($subItem);
        }
    }
}
?>
