<?php

namespace Mtc\Plugins\Agent\Models;

use App\Casts\OptionalEncrypted;
use Illuminate\Database\Eloquent\Model;

class AgentSettings extends Model
{
    protected $table = 'agent_settings';

    protected $fillable = [
        'title',
        'subtitle',
        'first_message',
        'input_max_tokens',
        'output_max_tokens',
        'background',
        'position',
        'steps',
        'output',
        'openai_api_key',
        'openai_model',
        'openai_embedding_model',
        'pinecone_api_key',
        'pinecone_index_url',
    ];

    protected $casts = [
        'openai_api_key' => OptionalEncrypted::class,
        'pinecone_api_key' => OptionalEncrypted::class,
    ];

    protected $appends = [
        'has_openai_key',
    ];

    public function getHasOpenaiKeyAttribute(): bool
    {
        return !empty($this->openai_api_key);
    }

    public function getHasPineconeKeyAttribute(): bool
    {
        return !empty($this->pinecone_api_key);
    }
}
