<?php
namespace Mtc\Plugins\Agent\Providers;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Mtc\Plugins\Agent\database\seeders\AgentSettingsSeeder;
use Mtc\Plugins\Agent\Events\ChatGenerated;
use Mtc\Plugins\Agent\Http\Middlewares\AgentAnonymous;
use Mtc\Plugins\Agent\Models\AgentSettings;

class AgentServiceProvider extends ServiceProvider {

    public function register() {
        // Register any application services.
        $this->loadRoutesFrom(__DIR__ . '/../routes/web.php');
        $this->mergeConfigFrom(__DIR__ . '/../config/neuron.php', 'neuron');
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');



        if (!config('neuron.enabled')) {
            return;
        }
    }

    public function boot(Router $router): void {
        $this->registerEvents();
        $this->seedAgentSettings();

        $router->aliasMiddleware('agent.anonymous', AgentAnonymous::class);
    }

    protected function seedAgentSettings(): void {
        if (Schema::hasTable('agent_settings') && AgentSettings::count() === 0) {
            $seeder = new AgentSettingsSeeder();
            $seeder->run();
        }
    }

    protected function registerEvents(): void {
        Event::listen(ChatGenerated::class, function (ChatGenerated $event) {});
    }

}
