<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_settings', function (Blueprint $table) {
            $table->id();
            $table->text('title');
            $table->text('subtitle');
            $table->text('first_message');
            $table->integer('input_max_tokens');
            $table->integer('output_max_tokens');
            $table->text('position');
            $table->text('openai_api_key')->nullable();
            $table->text('openai_model')->nullable();
            $table->text('openai_embedding_model')->nullable();
            $table->text('pinecone_api_key')->nullable();
            $table->text('pinecone_index_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_settings');
    }
};
