<?php

namespace Mtc\Plugins\Agent\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AgentSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('agent_settings')->delete();
        DB::table('agent_settings')->insert([
            'title' => 'Pharmacy Assistant',
            'subtitle' => 'Your friendly pharmacy support agent',
            'first_message' => 'Hello! I\'m your pharmacy assistant. How can I help you today?',
            'openai_model' => 'gpt-4o',
            'openai_embedding_model' => 'text-embedding-3-small',
            'input_max_tokens' => 3000000,
            'output_max_tokens' => 1000000,
            'position' => 'bottom-right',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}
