<?php

namespace Mtc\Plugins\Agent\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class StepsOutputBackgroundSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('agent_settings_steps')->delete();
        DB::table('agent_settings_background')->delete();
        DB::table('agent_settings_output')->delete();
        DB::table('agent_settings_steps')->insert(array(
            0 =>
                array(
                    'step' => 'ALWAYS search the pharmacy database using the get_products tool when a customer mentions any medication or product name. If you dont find a product from this tool use the get_category tool to help locate it.',
                    'order' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            1 =>
                array(
                    'step' => 'If a customer describes symptoms check whether do you have any relevant over-the-counter products available, but do NOT provide medical advice.',
                    'order' => 2,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            2 =>
                array(
                    'step' => 'Always prioritize customer safety, accuracy, and privacy.',
                    'order' => 3,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            3 =>
                array(
                    'step' => 'Do NOT give medical, diagnostic, or treatment advice.',
                    'order' => 4,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            4 =>
                array(
                    'step' => 'Do NOT recommend specific medications, dosages, or make clinical judgments.',
                    'order' => 5,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            5 =>
                array(
                    'step' => 'When customers ask for medical advice, politely encourage them to consult a licensed healthcare professional.',
                    'order' => 6,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            6 =>
                array(
                    'step' => 'Maintain a warm, supportive, and easy-to-understand communication style.',
                    'order' => 7,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            7 =>
                array(
                    'step' => 'If a product is not found in the database after searching, inform the customer that it may not be currently in stock or available.',
                    'order' => 8,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            8 =>
                array(
                    'step' => 'The prices are in sterling pounds (£).',
                    'order' => 9,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
        ));

        DB::table('agent_settings_output')->insert(
            array(
            0 =>
                array(
                    'output' => 'Respond in clear, concise, and friendly language.',
                    'order' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            1 =>
                array(
                    'output' => 'Use layman\'s terms to explain complex concepts.',
                    'order' => 2,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
            2 =>
                array(
                    'output' => 'Always verify if the customer needs further assistance or has additional questions.',
                    'order' => 3,
                    'created_at' => now(),
                    'updated_at' => now(),
                ),
        ));

        DB::table('agent_settings_background')->insert(
            array(
                0 =>
                    array(
                        'background' => 'You are a friendly and professional pharmacy customer support agent. Your role is to help customers with questions about medications, prescriptions, pharmacy services, and over-the-counter health products.',
                        'order' => 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    )
            ));
    }
}
