<?php
namespace  Mtc\Plugins\Agent;
use Illuminate\Support\Facades\Route;
use Mtc\Plugins\Agent\Http\Controllers\AgentSettingsController;
use Mtc\Plugins\Agent\Http\Controllers\ChatController;
use Mtc\Plugins\Agent\Http\Controllers\TokenUsageController;

Route::post('/agent/chat' , [ChatController::class, 'sendMessage'])->name('send-message');
Route::post('/agent/voice', [ChatController::class, 'audioWhisper'])->name('agents-voice');
Route::get('/agent/access', [AgentSettingsController::class, 'getTokenDailyUsage'])->name('agent-access');

Route::group(['middleware' => 'auth'], function() {
    Route::get('/admin/agent/chat-history/view/{id}', [ChatController::class, 'viewChatHistory'])->name('admin-agent-view-chat-history');
    Route::get('/admin/agent/chat-history', [ChatController::class, 'chatHistory'])->name('admin-agent-chat-history');

    // Token Usage Route
    Route::post('/admin/agent/token-usage', [TokenUsageController::class, 'getTokenCount'])->name('admin-agent-token-usage');

    // Agent Settings Routes
    Route::get('/admin/agent/settings', [AgentSettingsController::class, 'getSettings'])->name('admin-agent-get-settings');
    Route::post('/admin/agent/settings', [AgentSettingsController::class, 'updateSettings'])->name('admin-agent-update-settings');

    // Steps Management Routes
    Route::post('/admin/agent/settings/steps', [AgentSettingsController::class, 'addSteps'])->name('admin-agent-add-steps');
    Route::delete('/admin/agent/settings/steps/{id}', [AgentSettingsController::class, 'removeSteps'])->name('admin-agent-delete-steps');
    Route::put('/admin/agent/settings/steps/{id}', [AgentSettingsController::class, 'updateSteps'])->name('admin-agent-update-steps');
    Route::post('/admin/agent/settings/steps/swap', [AgentSettingsController::class, 'swapOrderSteps'])->name('admin-agent-swap-steps');

    // Output Management Routes
    Route::post('/admin/agent/settings/output', [AgentSettingsController::class, 'addOutput'])->name('admin-agent-add-output');
    Route::delete('/admin/agent/settings/output/{id}', [AgentSettingsController::class, 'removeOutput'])->name('admin-agent-delete-output');
    Route::put('/admin/agent/settings/output/{id}', [AgentSettingsController::class, 'updateOutput'])->name('admin-agent-update-output');
    Route::post('/admin/agent/settings/output/swap', [AgentSettingsController::class, 'swapOrderOutput'])->name('admin-agent-swap-output');

    // Background Management Routes
    Route::post('/admin/agent/settings/background', [AgentSettingsController::class, 'addBackground'])->name('admin-agent-add-background');
    Route::delete('/admin/agent/settings/background/{id}', [AgentSettingsController::class, 'removeBackground'])->name('admin-agent-delete-background');
    Route::put('/admin/agent/settings/background/{id}', [AgentSettingsController::class, 'updateBackground'])->name('admin-agent-update-background');
    Route::post('/admin/agent/settings/background/swap', [AgentSettingsController::class, 'swapOrderBackground'])->name('admin-agent-swap-background');


    Route::post('/admin/agent/settings/context/add', [AgentSettingsController::class, 'addContext'])->name('admin-agent-add-context');
});

?>
