<?php

    namespace Mtc\Plugins\Clinic\Http\Controllers\Admin;

    use Illuminate\Http\JsonResponse;
    use Mtc\Plugins\Clinic\Src\Services\PatientProfileBootstrapService;

    class PatientProfileController extends ClinicController
    {
        public function __construct(private readonly PatientProfileBootstrapService $bootstrapService)
        {
        }

        public function bootstrap($id): JsonResponse
        {
            $memberId = (int) $id;
            $payload = $this->bootstrapService->build($memberId);
            $payload['routes'] = app(PatientController::class)->patientRoutes($memberId);

            return response()
                ->json($payload)
                ->setPublic()
                ->setEtag(md5(json_encode($payload['responses'] ?? []) ?? ''))
                ->setMaxAge(60);
        }
    }
