<?php

namespace Mtc\Plugins\Clinic\Src;

class BMI
{

    const LB_TO_KG = 0.453592;
    const ST_TO_LB = 14;
    const IN_TO_CM = 2.54;
    const FT_TO_IN = 12;

    /**
     * Converts imperial weight (stones / pounds) to metric (kilograms)
     *
     * @param $weightSt
     * @param $weightLb
     * @return int
     */
    public static function convertWeightToMetric($weightSt, $weightLb): int
    {
        return (int)round(((int)$weightSt * self::ST_TO_LB + (int)$weightLb) * self::LB_TO_KG);
    }

    /**
     * Converts imperial height (feet / inches) to metric (centimeters)
     *
     * @param $heightFt
     * @param $heightIn
     * @return int
     */
    public static function convertHeightToMetric($heightFt, $heightIn): int
    {
        return (int)round(((int)$heightFt * self::FT_TO_IN + (int)$heightIn) * self::IN_TO_CM);
    }

    /**
     * Converts metric weight (kilograms) to imperial (stones / pounds)
     *
     * @param $weightKg
     * @return array
     */
    public static function convertWeightToImperial($weightKg): array
    {
        $pounds = round($weightKg / self::LB_TO_KG);
        return [
            floor($pounds / self::ST_TO_LB),
            $pounds % self::ST_TO_LB,
        ];
    }

    /**
     * Converts metric (centimeters) height to imperial (feet / inches)
     *
     * @param $heightCm
     * @return array
     */
    public static function convertHeightToImperial($heightCm): array
    {
        $inches = round($heightCm / self::IN_TO_CM);
        return [
            floor($inches / self::FT_TO_IN),
            $inches % self::FT_TO_IN,
        ];
    }

    /**
     * Calculates BMI
     *
     * @param $heightCm
     * @param $weightKg
     * @return string
     */
    public static function calculateBMI($heightCm, $weightKg): string
    {
        return number_format($weightKg / (($heightCm / 100)**2), 2);
    }
}