<?php

namespace Mtc\Plugins\Clinic\Src\Services;

use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Mtc\Modules\Members\Models\Member;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\BpTrackController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\ConsultationController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\EventLogController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\FileController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MemberAttributeController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MemberNoteController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MemberOrderController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MessageController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\ReviewController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\TreatmentController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\WeightTrackController;

class PatientProfileBootstrapService
{
    /**
     * Compile a bootstrap payload for the patient profile view.
     */
    public function build(int $memberId): array
    {
        $responses = [];

        $member = Member::query()->with('addressBilling')->find($memberId);

        $responses['admin-member-attributes-load'] = $this->decode(
            app(MemberAttributeController::class)->load($memberId)
        );

        $noteController = app(MemberNoteController::class);
        $responses['admin-member-notes-load'] = $this->decode($noteController->load($memberId));
        $responses['admin-member-notes-load-flags'] = $this->decode($noteController->loadFlags($memberId));

        $responses['admin-member-orders-load'] = $this->decode(
            app(MemberOrderController::class)->load($memberId)
        );

        $responses['admin-reviews-load'] = $this->decode(
            app(ReviewController::class)->load($this->request(['member_id' => $memberId]))
        );

        $responses['admin-patient-treatments-load'] = $this->decode(
            app(TreatmentController::class)->load($memberId)
        );

        $responses['admin-patient-files-load'] = $this->decode(
            app(FileController::class)->load($memberId)
        );

        $responses['admin-patient-consultations-load'] = $this->decode(
            app(ConsultationController::class)->load($memberId)
        );

        $responses['admin-patient-messages-load'] = $this->decode(
            app(MessageController::class)->load($memberId)
        );

        $responses['admin-patient-bp-track-load'] = $this->decode(
            app(BpTrackController::class)->load($memberId, $this->request())
        );

        $responses['admin-patient-weight-track-load'] = $this->decode(
            app(WeightTrackController::class)->load($memberId, $this->request())
        );

        $responses['admin-patient-event-log-load'] = $this->decode(
            app(EventLogController::class)->load($memberId)
        );
        $responses['admin-member-orders-load']=$this->decode(
            app(MemberOrderController::class)->load($memberId)
        );

        $responses['admin-reviews-load']=$this->decode(
            app(ReviewController::class)->load($this->request())
        );

        return [
            'member_id' => $memberId,
            'responses' => $responses,
            'attributes' => $responses['admin-member-attributes-load']['attributes'] ?? [],
            'notes' => $responses['admin-member-notes-load']['notes'] ?? [],
            'flags' => $responses['admin-member-notes-load-flags']['flags'] ?? [],
            'bp' => $responses['admin-patient-bp-track-load']['bpTrack'] ?? [],
            'orders'=>$responses['admin-member-orders-load']['orders'] ?? [],
            'reviews'=>$responses['admin-reviews-load']['reviews'] ?? [],
            'weightTrack' => $responses['admin-patient-weight-track-load']['weightTrack'] ?? [],
            'member' => $member ? [
                'id' => $member->id,
                'firstname' => $member->addressBilling->firstname ?? '',
                'lastname' => $member->addressBilling->lastname ?? '',
            ] : null,
            'todayDate' => Carbon::now()->format('d/m/Y'),
        ];
    }

    /**
     * Convert a JsonResponse to an array.
     */
    private function decode(JsonResponse $response): array
    {
        $data = $response->getData(true);
        return is_array($data) ? $data : [];
    }

    /**
     * Helper to create a lightweight POST request for controller methods that
     * expect an Illuminate Request instance.
     */
    private function request(array $parameters = []): Request
    {
        return Request::create('', 'POST', $parameters);
    }
}
