<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event_log', function (Blueprint $table) {
            $table->id();
            $table->string('loggable')->index();
            $table->unsignedBigInteger('loggable_id')->index()->nullable();
            $table->string('subject')->index();
            $table->text('value');
            $table->string('actor')->index();
            $table->unsignedBigInteger('actor_id')->index()->nullable();
            $table->string('ip_address', 15)->index();
            $table->text('details');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('event_log');
    }
};
