<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assessment_ethnicities', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Add indexes for performance
            $table->index('name');
            $table->index('is_active');
            $table->index('sort_order');
        });

        Schema::create('assessment_bmi_ethnicities', function (Blueprint $table) {
            $table->id();
            $table->string('bmi_category'); // Obesity, Overweight, Underweight, Normal Weight
            $table->foreignId('ethnicity_id')->constrained('assessment_ethnicities')->onDelete('cascade');
            $table->float('cutoff_low')->nullable();
            $table->float('cutoff_high')->nullable();
            $table->text('message')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Add indexes for performance
            $table->index('bmi_category');
            $table->index('ethnicity_id');
            $table->index('is_active');
            $table->index(['ethnicity_id', 'bmi_category']); // Composite index for common queries
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assessment_bmi_ethnicities');
        Schema::dropIfExists('assessment_ethnicities');
    }
};
