<?php
/**
 * Install Featured Products
 *
 * Add FEATURED_ITEMS constant to allow enabling / disabling.
 * Set up database for admin panel.
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

if (empty($path)) {
    $path = '../../../../';
    require_once $path . "core/includes/header.inc.php";
    $display_message = true;
}

use Illuminate\Database\Capsule\Manager as Capsule;
use Mtc\Core\Setting;

$data = [
    [
        'key' => 'CUSTOMERS_ALSO_VIEWED_ENABLE',
        'type' => 'bool',
        'value' => true,
        'module' => 'Customers Also Viewed',
        'description' => 'Set true to enable Customers Also Viewed for items',
        'created_at' => new \DateTime(),
    ]
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

Setting::Insert($data);

// Add Table to database

$path_to_admin_folder = str_replace(SITE_PATH, "", dirname(__DIR__));

$schema = Capsule::connection()->getSchemaBuilder();

// Check if the table exists. If it doesn't, build it.
if ($schema->hasTable('customers_also_viewed') === false) {
    // Build the table
    $schema->create('customers_also_viewed', function ($table) {
        $table->increments('id');
        $table->integer('item_id');
        $table->integer('also_viewed_id');
        $table->integer('views');
        $table->timestamps();
        $table->index('id');
        $table->index('item_id');
        $table->index('also_viewed_id');
        $table->index('views');
    });
}

if ($display_message === true) {
    exit('Install successful');
}
