<?php
/**
 * Featured Items Admin
 *
 * Provide an admin panel to select featured items
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

namespace Mtc\Plugins\FeaturedProducts\Classes;

use Item;

$path = '../../../';
$page_meta['title'] = 'Featured Products';

require_once $path . 'core/includes/header.inc.php';

require_once $path . 'core/admin/templates/adminheader.html.php';

$errors = [];

//checking for duplicate input
if (!empty($_REQUEST['item_id'])) {
    $brand_duplicate_bool = FeaturedProducts::where('item_id', $_REQUEST['item_id'])
        ->exists();
    if ($brand_duplicate_bool == true) {
        $errors['duplicate'] = 'This item is already added';
    }
}

if (!empty($_REQUEST['action'])) {
    if ($_REQUEST['action'] == 'add') {

        //checking for empty input
        if (empty($_REQUEST['item_id'])) {
            $errors['name'] = 'Please select Item ID';
        }
        elseif (!empty($_REQUEST['item_id']) && is_numeric($_REQUEST['item_id']) &&
                sizeof($errors) == 0) {

            //adding new featured product
            FeaturedProducts::create([
                'item_id' => $_REQUEST['item_id']
            ]);
        }
    }
    if ($_REQUEST['action'] == 'delete') {

        //deleting featured product
        if (!empty($_REQUEST['delete_id']) && is_numeric($_REQUEST['delete_id'])) {
            FeaturedProducts::where('item_id', $_REQUEST['delete_id'])->delete();
        }
    }
}

//displaying errors
if (!empty($errors)) {
    showerrors($errors);
}

//getting all featured products in the right order
$featured_products = FeaturedProducts::getForDisplay();
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Admin</a> /</li>
    <li class="end">Featured Products</li>
</ul>

<h1>Featured Products</h1>

    <form action="" enctype="multipart/form-data" method="post" class="style">

        <fieldset class="show">
            <h1>
                <a href="#" class="show el">
                    Add Product <i class="fa fa-caret-down"></i>
                </a>
            </h1>
            <div class="row">
                <label for="item_id_name">Item ID</label>
                <input type="hidden" name="item_id" id="item_id" class="INPUT1"/>
                <input type="text" name="item_id_name" id="item_id_name" class="INPUT1 short"/>
                <a class="browseForFeaturedItems btn">Browse</a>
                <a class="btn cancel clearFeaturedItem">Clear</a>
            </div>

            <?php
            if (!empty($_REQUEST['sex'])) {
                ?>
                <input type="hidden" name="sex" value="<?= clean_page($_REQUEST['sex']); ?>"/>
                <?php
            }
            ?>

            <input type="hidden" name="action" value="add"/>

            <div class="row">
                <input type="submit" value="Add"/>
            </div>

        </fieldset>

    </form>

<?php
if ($featured_products->isEmpty() === false) {
?>

    <table class="manage-items">
        <tr>
            <th class="center">Order</th>
            <th>Product ID</th>
            <th>Product</th>
            <th>Image</th>
            <th class="center">Delete</th>
        </tr>
        <tbody class="tabular ui-sortable">
            <?php
            foreach ($featured_products as $featured_product) {
                $item_eloquent = \Mtc\Shop\Item::find($featured_product->item_id);
                if (! $item_eloquent) continue;
                ?>

                <tr id="rorder-<?= $featured_product->id ?>">
                    <td class="center order">
                        <i class="fa fa-arrows"></i>
                    </td>

                    <td>
                        <?= clean_page($item_eloquent->id) ?>
                    </td>

                    <td>
                        <?= clean_page($item_eloquent->name) ?>
                    </td>

                    <td>
                        <img
                            src="<?= $item_eloquent->getImagePath('default', 'smallthumbs') ?>"
                            alt="Featured product thumbnail"
                        />
                    </td>

                    <td class="center">
                        <?php
                        if (!empty($_REQUEST['sex'])) {
                            $sex_field = '&sex=' . clean_page($_REQUEST['sex']);
                        } else {
                            $sex_field = null;
                        }
                        ?>

                        <a href="index.php?action=delete&delete_id=<?= $featured_product->item_id ?>"
                            class="alert picto error"
                            title="Are you sure you want to delete this featured item?">
                                <i class="fa fa-times-circle"></i>
                        </a>
                    </td>
                </tr>

            <?php
            }
            ?>

            <input type="hidden" id="orderbytable" value="featured_products" />
            <input type="hidden" id="orderbyfield" value="order" />

        </tbody>
    </table>

<?php
} else {
    ?>
    <p>You have not added any featured products</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
