<?php
/**
 * FeefoReviewsLogs Class
 *
 * This code is used to log data for FeefoReviews requests and responses
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   Davis Lasis <davis.lasis@mtcmedia.co.uk>
 * @version  v3.0
 */
namespace Mtc\Plugins\FeefoReviews\Classes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\ModelNotFoundException;

/**
 * FeefoReviewsLogs Class. Extends eloquent model.
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   mtc. Davis Lasis <davis.lasis@mtcmedia.co.uk>
 */
class FeefoReviewsLogs extends Model
{
    /**
     * @var String Classes associated table
     */
    protected $table = 'feefo_reviews_logs';

    /**
     * @var mixed List of fillable DB columns
     */
    protected $fillable = ['request', 'response'];

    /**
     * @var bool use DB timestamps
     */
    public $timestamps = true;

    /**
     * Saves log data in DB
     *
     * @access public
     * @param request $request Enter Sales Remotely request
     * @param response $response Enter Sales Remotely response
     * @return bool
     */
    public static function insertLog($request, $response)
    {
        $insert_data = [
            'request' => json_encode($request),
            'response' => json_encode($response),
        ];
        return self::create($insert_data);
    }

    /**
     * Deletes log data from DB older than 1 year
     *
     * @access public
     * @return bool
     */
    public static function deleteLogs()
    {
        $date = new \DateTime();
        $date->modify('-1 year');
        $formatted_date = $date->format('Y-m-d H:i:s');
        return self::where('created_at', '<=', $formatted_date)->delete();
    }
}
