<?php
/**
 * FeefoReviewsSettings Class
 *
 * This code is used to update settings data for FeefoReviews summary reviews schema
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   Davis Lasis <davis.lasis@mtcmedia.co.uk>
 * @version  v3.0
 */
namespace Mtc\Plugins\FeefoReviews\Classes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\ModelNotFoundException;

/**
 * FeefoReviewsSettings Class. Extends eloquent model.
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   mtc. Davis Lasis <davis.lasis@mtcmedia.co.uk>
 */
class FeefoReviewsSettings extends Model
{
    /**
     * @var String Classes associated table
     */
    protected $table = 'feefo_reviews_settings';

    /**
     * @var mixed List of fillable DB columns
     */
    protected $fillable = ['name', 'url', 'telephone', 'streetAddress', 'addressLocality', 'addressLocality2', 'addressCountry'];

    /**
     * @var bool use DB timestamps
     */
    public $timestamps = true;

    /**
     * Returns settings DB column map
     *
     * @access public
     * @return array
     */
    public static function columnMap()
    {
        $settings_map = [
            'organisation' => [
                'name' => 'Name',
                'url' => 'Url',
                'telephone' => 'Telephone',
            ],
            'address' => [
                'streetAddress' => 'Street',
                'addressLocality' => 'Locality',
                'addressLocality2' => 'Locality',
                'addressCountry' => 'Country'
            ],
        ];
        return $settings_map;
    }

}
