<?php
use Mtc\Plugins\FeefoReviews\Classes\FeefoReviews;

/**
 * Feefo Reviews
 *
 * Add Feefo Reviews hooks
 *
 * @author Davis Lasis <davis.lasis@mtcmedia.co.uk>
 * @version v3.0
 */

if (defined('FEEFO_REVIEWS_ENABLED') && FEEFO_REVIEWS_ENABLED === true) {

    /**
     * Renders a Feefo homepage badge
     */
    HooksAdapter::add_action(
        'feefo_homepage_badge',
        '\Mtc\Plugins\FeefoReviews\Classes\FeefoReviews::homepageBadge',
        10,
        0,
        [$twig]
    );

    /**
     * Renders schema.org/Organization and schema.org/AggregateRating summary schema
     */
    HooksAdapter::add_action(
        'feefo_homepage_summary_schema',
        '\Mtc\Plugins\FeefoReviews\Classes\FeefoReviews::getHomepageSummarySchema',
        10,
        0,
        [$twig]
    );

    /**
     * Renders latest Feefo reviews
     */
    if (FEEFO_REVIEWS_LATEST_REVIEWS === true) {
        HooksAdapter::add_action(
            'feefo_latest_reviews',
            '\Mtc\Plugins\FeefoReviews\Classes\FeefoReviews::latestReviews',
            10,
            0,
            [$twig]
        );
    }

    /**
     * Renders a Feefo reviews for particular item
     */
    if (FEEFO_REVIEWS_ITEM_REVIEWS === true) {
        HooksAdapter::add_action(
            'feefo_item_reviews',
            '\Mtc\Plugins\FeefoReviews\Classes\FeefoReviews::itemReviews',
            10,
            1,
            [$twig]
        );

        HooksAdapter::add_action(
            'feefo_item_reviews_badge',
            '\Mtc\Plugins\FeefoReviews\Classes\FeefoReviews::itemReviewsBadge',
            10,
            1,
            [$twig]
        );
    }

    /**
     * Sends sales data remotely to Feefo server
     */
    if (FEEFO_REVIEWS_ENTER_SALES_REMOTELY === true) {
        HooksAdapter::add_action(
            'Order/markPaid',
            '\Mtc\Plugins\FeefoReviews\Classes\FeefoReviews::enterSalesRemotely',
            10,
            1
        );
    }

}
