<?php

$path = '../../../../';
require_once $path . 'core/includes/header.inc.php';

error_reporting(E_ALL & ~E_WARNING);
header('Content-Type: application/json');

if(empty($_SESSION['basket_id'])) {
    http_response_code(403);
    die;
}

$basket = new Basket();

$basket->Go_Basket();

if(!empty($address = $_POST['shippingAddress'] ?? '')) {
    $basket->setCustomerAddress('billing', array_merge($basket->address['billing'], [
        'country'       => $address['countryCode'] ?? '',
        'postcode'      => $address['postalCode'] ?? '',
        'city'          => $address['locality'] ?? '',
    ]));
    $basket->updateBillingAddressUsed(1);
}

if(!empty($delivery = $_POST['shippingOption'] ?? '')) {
    $basket->delivery_selected = (int) $delivery['id'];
    $basket->Set_Delivery_Cost();
}

$basket->resetSession();

$basket = new \Basket();

$basket->Go_Basket();

$apay = new \Mtc\Plugins\Judopay\Classes\APay($basket);
$res = $apay->getPaymentDataRequestUpdate();
$errors = $apay->validateBasket([
    'address'       => true,
]);

if(!empty($errors)) {
    $res['paymentMethodErrors'] = $errors;
}

echo json_encode($res);
die;
