<?php
/**
 * ID check Installer
 *
 * Adds required settings to site as they are pushed live with settings.db.php
 * Rest of the changes are populated through migrations
 *
 * This requires shop to be present
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Mtc\Core\Setting;

$data = [
    [
        'key' => 'LN_IDU_ENABLED',
        'type' => 'bool',
        'value' => true,
        'module' => 'LN ID Checks',
        'description' => 'Enable / Disable ID Checks plugin',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'LN_IDU_USERNAME',
        'type' => 'string',
        'value' => '',
        'module' => 'LN ID Checks',
        'description' => 'Username used by the API',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'LN_IDU_PASSWORD',
        'type' => 'string',
        'value' => '',
        'module' => 'LN ID Checks',
        'description' => 'Password used by the API',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'LN_IDU_TEST',
        'type' => 'bool',
        'value' => true,
        'module' => 'LN ID Checks',
        'description' => 'Run Test or live mode for the ID checks',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'LN_IDU_USERNAME_TEST',
        'type' => 'string',
        'value' => '',
        'module' => 'LN ID Checks',
        'description' => 'Username used by the API',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'LN_IDU_PASSWORD_TEST',
        'type' => 'string',
        'value' => '',
        'module' => 'LN ID Checks',
        'description' => 'Password used by the API',
        'created_at' => new \DateTime(),
    ]
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

Setting::Insert($data);

$source = __DIR__ . '/20171102-1-AddLNIDChecksTables.php';
$destination = SITE_PATH . '/migrations/20171102-1-AddLNIDChecksTables.php';

// Copy the migration file over to migrations dir
if (!file_exists($destination)) {
    copy($source, $destination);

    exec('/usr/local/bin/php ' . SITE_PATH . '/migrations.php');
}