<?php

namespace Mtc\Modules\MembersMessaging\Classes;

use Mtc\Core\Admin\User;
use Mtc\Plugins\MembersMessaging\Classes\Thread;
use Mtc\Plugins\MembersMessaging\Classes\ViewFixer;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'act',
    'return',
    'id',
    'startnumber',
]);

$page_meta['title'] = 'Archived messages';

$action = filter_var($_REQUEST['act'], FILTER_SANITIZE_STRING);
$return = filter_var($_REQUEST['return'], FILTER_SANITIZE_STRING);
$id = filter_var($_REQUEST['id'], FILTER_SANITIZE_NUMBER_INT);

if($action === 'restore') {
    Thread::withTrashed()
        ->where('id', $id)
        ->restore();
    if(!empty($return)) {
        header('Location: ' . $return);
        exit;
    }
}

if (is_numeric($_REQUEST['startnumber'])) {
    $startnumber = $_REQUEST['startnumber'];
} else {
    $startnumber = 0;
}


$query = Thread::onlyTrashed()
    ->orderBy('deleted_at', 'DESC');

(new ViewFixer())->resolvePaginationDependencies($twig);

$threads = $query->paginate(25);

$threads->appends($_GET);

$totalnumrows = $threads->total();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Archived messages</li>
    </ul>

    <h1>Archived messages</h1>

    <?php
require 'tabnav.php';
if ($totalnumrows > 0) {
    ?>
    <table class="manage-items">
        <tr>
            <th class="center">ID</th>
            <th>Member</th>
            <th>Category</th>
            <th>Message</th>
            <th>Date sent</th>
            <th></th>
        </tr>
        <tbody class="tabular">
        <?php
        foreach ($threads as $thread) {
            $first_message = $thread->messages->first();
            ?>
            <tr id="rorder-<?= $thread->id ?>">
                <td>
                    <?= clean_page($thread->id) ?>
                </td>
                <td>
                    <?= clean_page($first_message->user->fullname ?? ''); ?>
                </td>
                <td>
                    <?= Thread::MESSAGE_CATEGORIES[$thread->category]; ?>
                </td>
                <td>
                    <?= strip_tags($first_message->text); ?>
                </td>
                <td>
                    <?= clean_page($first_message->created_at); ?>
                </td>
                <td>
                    <a class="view-message" href="view_member_thread.php?url=<?= $thread->url; ?>"><i class="fa fa-eye"></i> View message</a>
                    <a class="delete-message alert" title="Are you sure you want to restore this thread?" href="archive.php?act=restore&id=<?=$thread->id; ?>&return=<?= $_SERVER['SCRIPT_NAME']; ?>"><i class="fa fa-retweet"></i> Restore thread</a>

                </td>
            </tr>
            <?php
        }
        ?>
        </tbody>
    </table>
    <?php
} else {
    ?>
    <p>There are no archived messages</p>
    <?php
}

echo $threads->render();

require_once $path . 'core/admin/templates/adminfooter.html.php';
