<?php

namespace Mtc\Modules\MembersMessaging\Classes;


use Mtc\Plugins\MembersMessaging\Classes\Templates;
use Mtc\Plugins\MembersMessaging\Classes\ViewFixer;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'act',
    'startnumber',
]);

$page_meta['title'] = 'Doctor message templates';

$action = filter_var($_REQUEST['act'], FILTER_SANITIZE_STRING);

if($action === 'assign_admin') {
    $thread_url = filter_var($_REQUEST['thread'], FILTER_SANITIZE_STRING);
    $user = filter_var($_REQUEST['user_id'], FILTER_SANITIZE_NUMBER_INT);

    $admin = \Mtc\Core\Admin\User::find($user);

    $thread = Thread::whereUrl($thread_url)->first();
    $thread->assignAdmin($admin);

    header('Location: /plugins/MembersMessaging/admin/');
    exit;
}

if($action === 'delete') {
    Templates::query()->where('id', '=', $_REQUEST['id'])->delete();
    header('Location: /plugins/MembersMessaging/admin/edit_templates.php');
    exit;
}

if (is_numeric($_REQUEST['startnumber'])) {
    $startnumber = $_REQUEST['startnumber'];
} else {
    $startnumber = 0;
}

$query = Templates::query();
$query->orderBy('id', 'ASC');

(new ViewFixer())->resolvePaginationDependencies($twig);

$templates = $query->paginate(25);

$templates->appends($_GET);

$totalnumrows = $templates->total();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Doctor message templates</li>
    </ul>

    <h1>Doctor message templates</h1>

    <?php
require 'tabnav.php';
if ($totalnumrows > 0) {
    ?>
    <table class="manage-items">
        <tr>
            <th class="center">ID</th>
            <th>Category</th>
            <th>Name</th>
            <th>Text</th>
            <th></th>
        </tr>
        <tbody class="tabular">
        <?php
        foreach ($templates as $template) {
            ?>
            <tr id="rorder-<?= $template->id ?>">
                <td>
                    <?= clean_page($template->id) ?>
                </td>
                <td>
                    <?= clean_page(Templates::$categories[$template->category]); ?>
                </td>
                <td>
                    <?= clean_page($template->name); ?>
                </td>
                <td>
                    <?= clean_page(strip_tags($template->text)); ?>
                </td>
                <td>
                    <a class="view-message" href="edit_template.php?id=<?= $template->id; ?>"><i class="fa fa-pencil"></i> Edit template</a>
                    <a class="alert" title="Are you sure you want to remove this?" href="edit_templates.php?id=<?= $template->id; ?>&act=delete"><i class="fa fa-remove"></i> Remove template</a>
                </td>
            </tr>
            <?php
        }
        ?>
        </tbody>
    </table>
    <?php
} else {
    ?>
    <p>There are no templates</p>
    <?php
}

echo $templates->render();

require_once $path . 'core/admin/templates/adminfooter.html.php';
