<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRealexTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_realex', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id');
            $table->decimal('amount_paid', 10, 2);
            $table->string('tnx_id', 50);
            $table->datetime('paid_time')->nullable();
            $table->timestamps();

            $table->foreign('order_id')
                  ->references('id')
                  ->on('order')
                  ->constrained()
                  ->onDelete('restrict')
                  ->onUpdate('cascade')
              ;
        });

        Schema::create('realex_responses', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id');
            $table->string('type', 255);
            $table->text('response');
            $table->timestamps();

            $table->foreign('order_id')
                  ->references('id')
                  ->on('order')
                  ->constrained()
                  ->onDelete('restrict')
                  ->onUpdate('cascade')
              ;
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_realex');
        Schema::dropIfExists('realex_responses');
    }
}
