$().ready(function () {
    Vue.component('seo-schema', {
        template: "#seoSchemaTemplate",
        props: [
            'id',
            'itemId'
        ],
        data: function() {
            return {
                item: {},
                newItem: '',
                newItemType: 'text',
                isLoading: true,
                showNew: false,
                processing: false
            }
        },
        created: function() {
            this.isLoading = true;
            if (typeof(this.id) == 'undefined') {
                this.$http.post('/plugins/SeoSchema/admin/ajax.php', {
                    item_id: this.itemId,
                    action: 'load'
                }).then(function(response) {
                    this.item = response.data.data;
                    this.isLoading = false;
                });
            } else {
                this.$http.post('/plugins/SeoSchema/admin/ajax.php', {
                    item_id: this.itemId,
                    id: this.id,
                    action: 'load'
                }).then(function(response) {
                    this.item = response.data.data;
                    this.isLoading = false;
                });
            }
        },
        methods: {
            addNewItem: function() {
                this.$http.post('/plugins/SeoSchema/admin/ajax.php', {
                    item_id: this.itemId,
                    id: this.id,
                    field: this.newItem,
                    type: this.newItemType,
                    action: 'add_item'
                }).then(function(response) {
                    this.newItem = '';
                    this.item = response.data.data;
                    this.showNew = false;
                });
            },
            updateField: function(child_id, field) {
                this.processing = true;
                this.$http.post('/plugins/SeoSchema/admin/ajax.php', {
                    item_id: this.itemId,
                    id: child_id,
                    type: this.newItemType,
                    field: field,
                    action: 'update_field'
                }).then(function(response) {
                    this.newItem = '';
                    this.item = response.data.data;
                    this.processing = false;
                });
            },
            updateValue: function(child_id, value) {
                this.processing = true;
                this.$http.post('/plugins/SeoSchema/admin/ajax.php', {
                    item_id: this.itemId,
                    id: child_id,
                    field: this.newItem,
                    type: this.newItemType,
                    value: value,
                    action: 'update_value'
                }).then(function(response) {
                    this.newItem = '';
                    this.item = response.data.data;
                    this.processing = false;
                });
            },
            removeItem: function(child_id) {
                this.$http.post('/plugins/SeoSchema/admin/ajax.php', {
                    item_id: this.itemId,
                    id: child_id,
                    action: 'remove'
                }).then(function(response) {
                    this.newItem = '';
                    this.item = response.data.data;
                });
            }
        }
    })
});