<?php
/**
 * Static Block Class
 *
 * This code is used to make up Static Blocks and their modification
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\StaticBlocks\Classes;
use Illuminate\Database\Eloquent\Model;

/**
 * Static Block Class. Eloquent model class that creates static block
 * functionality. Stores getBlock function which renders block
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
Class StaticBlocksInstances extends Model
{
    /**
     * @var String Classes associated table
     */
    protected $table = 'static_blocks_instances';

    protected $fillable = [
        'static_block_id',
        'url',
        'alt_text',
        'size',
        'image',
        'content'
    ];

    /**
     * StaticBlocksInstances::block()
     *
     * Define relationship with the static block
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function block()
    {
        return $this->belongsTo(StaticBlocks::class, 'static_block_id');
    }

}