<?php

// run the installer script
use Illuminate\Database\Capsule\Manager as Capsule;

$schema = Capsule::connection()->getSchemaBuilder();

// define settings array
$data = [
    [
        'key'         => 'TRUSTPILOT_API_ENABLED',
        'type'        => 'bool',
        'value'       => 0,
        'module'      => 'TrustpilotAPI',
        'description' => 'Turn on/off Trustpilot API plugin',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'TRUSTPILOT_API_REVIEWS',
        'type'        => 'int',
        'value'       => 0,
        'module'      => 'TrustpilotAPI',
        'description' => 'Review count to show',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'TRUSTPILOT_API_KEY',
        'type'        => 'string',
        'value'       => '',
        'module'      => 'TrustpilotAPI',
        'description' => 'Trustpilot API key',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'TRUSTPILOT_API_SECRET',
        'type'        => 'string',
        'value'       => '',
        'module'      => 'TrustpilotAPI',
        'description' => 'Trustpilot API secret key',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'TRUSTPILOT_API_BUSINESS_ID',
        'type'        => 'string',
        'value'       => '',
        'module'      => 'TrustpilotAPI',
        'description' => 'Trustpilot business unit ID',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'TRUSTPILOT_API_ENABLE_CACHE',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => 'TrustpilotAPI',
        'description' => 'Enable/Disable truspilot cache',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'TRUSTPILOT_API_CACHE_TIME',
        'type'        => 'int',
        'value'       => 3600,
        'module'      => 'TrustpilotAPI',
        'description' => 'Cache time in seconds (Default 3600)',
        'created_at'  => new DateTime(),
    ],
];

// Save Dafault Settings
MTC\Core\Setting::Insert($data);

// Create trustpilot_settings table if 
// it doesn't exist and assign default values
if ($schema->hasTable('trustpilot_settings') === false) {
    $schema->create(
        'trustpilot_settings',
        function ($table) {
            $table->increments('id')->unsigned();
            $table->string('key')->unique();
            $table->string('value');
        }
    );

    Capsule::table('trustpilot_settings')->insert([
        'key'     => 'SEND_AFTER',
        'value'   => '3'
    ]);

    Capsule::table('trustpilot_settings')->insert([
        'key'     => 'SEND_BATCH_SIZE',
        'value'   => '167'
    ]);

    Capsule::table('trustpilot_settings')->insert([
        'key'     => 'ACCESS_TOKEN',
        'value'   => ''
    ]);

    Capsule::table('trustpilot_settings')->insert([
        'key'     => 'REFRESH_TOKEN',
        'value'   => ''
    ]);
}
