<?php

namespace Mtc\Plugins\Wisebee\Classes\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Core\AdminUser;

/**
 * Accessors
 *
 * @property int $id
 * @property int $wisebee_id
 * @property int $admin_user_id
 * @property string $updated_at
 * @property string $created_at
 *
 */

class WisebeeUser extends Model
{
    protected $table = 'wisebee_users';

    protected $fillable = [
        'wisebee_id',
        'admin_user_id',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(AdminUser::class, 'admin_user_id');
    }
}