<?php

namespace MtcPharmacy\Subscriptions\Http\Controllers\Admin;

use Illuminate\Http\Request;
use MtcPharmacy\Subscriptions\Classes\Subscription;
use MtcPharmacy\Subscriptions\Classes\SubscriptionPreference;


class SubscriptionPreferencesController extends \App\Http\Controllers\Controller
{

    public function update(Request $request)
    {
        $input_data = $request->input('data');

        foreach ($input_data as $line) {
            $sp = SubscriptionPreference::query()
                ->where('item_id', $line['item_id'])
                ->where('item_size_id', $line['item_size_id'])
                ->first()
            ;

            if ($sp) {
                $sp->update((array)$line);
            }
        }

        return [
            'success' => true,
        ];
    }


    public function get_data($item_id, Request $request)
    {
        SubscriptionPreference::ensureItemPreferencesExist($item_id);

        $subscription_preferences = SubscriptionPreference::query()
            ->with('shop_item')
            ->with('shop_item_size')
            ->where('item_id', $item_id)
            ->orderBy('item_size_id', 'asc')
            ->get()
        ; 

        return [
            'data' => $subscription_preferences,
            'allowed_intervals' => Subscription::get_allowed_intervals(),
        ];
    }

}



