Vue.component('subscription-preferences', {

    props: [
        "dataUrl",
        "saveDataUrl",
        "labels",
    ],

    data: function() {
        return {
            sub_preferences: [],
            allowed_intervals: [],
            isBusy: false,
            all_ticked: {
                is_allowed: false,
                is_required: false,
                can_be_paused: false,
                max_number_of_issues: false,
                interval_multiplier: false,
                interval: false,
            },
        };
    },

    created: function() {
        this.fetchSusbscriptionPreferences();
    },

    methods: {

        useSelectedTemplate: function() {

            if (this.selected_note_template_id > 0) {
                for (let i = 0 ; i < this.note_templates.length; i++) {
                    if (this.note_templates[i].id == this.selected_note_template_id) {
                        this.new_note = this.note_templates[i].content;
                    }
                }
            }

        },

        fetchSusbscriptionPreferences: function() {
            var that = this;

            fetch(this.dataUrl, {
                method: 'GET',
            })
            .then(response => response.json())
            .then(data => {
                that.sub_preferences = data.data;
                that.allowed_intervals = data.allowed_intervals;
            });
        },

        saveData: function() {
            var that = this;

            let submit_data = {
                data: this.sub_preferences,
            };

            this.isBusy = true;

            fetch(this.saveDataUrl, {
                method: 'POST',
                body: JSON.stringify(submit_data),
                headers: {
                    'Content-Type': 'application/json'
                },
            })
            .then(response => response.json())
            .then(data => {
                that.isBusy = false;
            });
        },

        updateAll: function(property_name) {
            for (let i = 0; i < this.sub_preferences.length; i++) {
                this.sub_preferences[i][property_name] = this.all_ticked[property_name];
            }
        },

    },

    template: `
        <section>

            <table class="manage-items" border="0">

                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Item variation</th>
                        <th>Is allowed?</th>
                        <th>Is required?</th>
                        <th>Can be paused?</th>
                        <th>Max number of issues</th>
                        <th v-text="labels.interval_multiplier || 'Interval multiplier'"></th>
                        <th v-text="labels.interval || 'Interval'"></th>
                    </tr>
                </thead>


                <tbody class="tabular">

                    <tr v-for="sub_config in sub_preferences">
                        <td
                            v-text="sub_config.shop_item.name"
                            style=""
                        ></td>
                        <td
                            v-text="sub_config.shop_item_size ? sub_config.shop_item_size.size : ''"
                            style="vertical-align: middle"
                        ></td>
                        <td style="">
                            <input
                                type="checkbox"
                                value="1"
                                v-model="sub_config.is_allowed"
                            />
                        </td>
                        <td style="">
                            <input
                                type="checkbox"
                                value="1"
                                v-model="sub_config.is_required"
                            />
                        </td>
                        <td style="">
                            <input
                                type="checkbox"
                                value="1"
                                v-model="sub_config.can_be_paused"
                            />
                        </td>
                        <td>
                            <input
                                type="number"
                                v-model="sub_config.max_number_of_issues"
                            />
                        </td>
                        <td>
                            <input
                                type="number"
                                v-model="sub_config.interval_multiplier"
                            />
                        </td>
                        <td>
                            <select
                                v-model="sub_config.interval"
                            >
                                <option v-for="allowed_interval in allowed_intervals"
                                    :value="allowed_interval"
                                    v-text="allowed_interval"
                                ></option>
                            </select>
                        </td>
                    </tr>

                    <tr style="background-color:#dddddd" v-if="sub_preferences.length > 1">
                        <th
                            v-text="'Update all'"
                        ></th>
                        <td
                            v-text=""
                        ></td>
                        <td style="padding-top: 3px; vertical-align: middle;">
                            <input
                                type="checkbox"
                                value="1"
                                v-model="all_ticked.is_allowed"
                                @change="updateAll('is_allowed')"
                            />
                        </td>
                        <td style="padding-top: 3px; vertical-align: middle;">
                            <input
                                type="checkbox"
                                value="1"
                                v-model="all_ticked.is_required"
                                @change="updateAll('is_required')"
                            />
                        </td>
                        <td style="padding-top: 3px; vertical-align: middle;">
                            <input
                                type="checkbox"
                                value="1"
                                v-model="all_ticked.can_be_paused"
                                @change="updateAll('can_be_paused')"
                            />
                        </td>
                        <td>
                            <input
                                type="number"
                                v-model="all_ticked.max_number_of_issues"
                                @change="updateAll('max_number_of_issues')"
                            />
                        </td>
                        <td>
                            <input
                                type="number"
                                v-model="all_ticked.interval_multiplier"
                                @change="updateAll('interval_multiplier')"
                            />
                        </td>
                        <td>
                            <select
                                v-model="all_ticked.interval"
                                @change="updateAll('interval')"
                            >
                                <option v-for="allowed_interval in allowed_intervals"
                                    :value="allowed_interval"
                                    v-text="allowed_interval"
                                ></option>
                            </select>
                        </td>
                    </tr>
                </tbody>

            </table>

            <div class="row">
                <button
                    @click.prevent="saveData"
                    class="btn btn-secondary"
                    v-text="isBusy ? 'Saving...' : 'Save subscription preferences'"
                    :disabled="isBusy"
                ></button>
            </div>

        </section>
    `,

});
