<?php

\Route::group([

    'middleware' => 'web' // Required for Laravel sessions to work.

], function() {

    /* Admin pages */

    \Route::get('admin/subscriptions', [
        'as' => 'admin-subscriptions',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@manage'
    ]);

    \Route::get('admin/subscriptions/data', [
        'as' => 'admin-subscriptions-data',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@data'
    ]);

    \Route::get('admin/subscriptions/generate-order/{subscription_id}', [
        'as' => 'admin-subscriptions-generate-order',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@generate_order'
    ]);

    \Route::get('admin/subscriptions/edit/{subscription_id?}', [
        'as' => 'admin-subscriptions-edit',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@edit'
    ]);

    \Route::post('admin/subscriptions/edit/{subscription_id}', [
        'as' => 'admin-subscriptions-update',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@update'
    ]);

    \Route::get('admin/subscriptions/items/delete/{subscription_item_id}', [
        'as' => 'admin-subscriptions-items-delete',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@delete_item'
    ]);

    \Route::get('admin/subscriptions/create/{member_id}', [
        'as' => 'admin-subscriptions-create',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionsController@create',
        'group' => 'auth',
    ]);

    \Route::post('admin/subscriptions/preferences/data', [
        'as' => 'admin-subscription-preferences-data-update',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionPreferencesController@update',
        'group' => 'auth',
    ]);

    \Route::get('admin/subscriptions/preferences/data/{item_id?}', [
        'as' => 'admin-subscription-preferences-data',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\Admin\SubscriptionPreferencesController@get_data',
        'group' => 'auth',
    ]);


    /* Front-end pages */

    \Route::get('subscription/{subscription_id}/set-paused', [
        'as' => 'fe-subscription-set-paused',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\SubscriptionsController@set_paused',
        'group' => 'auth',
    ]);

    \Route::get('subscription/{subscription_id}/set-active', [
        'as' => 'fe-subscription-set-active',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\SubscriptionsController@set_active',
        'group' => 'auth',
    ]);

    \Route::get('subscription/{subscription_id}/set-cancelled', [
        'as' => 'fe-subscription-set-cancelled',
        'uses' => 'MtcPharmacy\Subscriptions\Http\Controllers\SubscriptionsController@set_cancelled',
        'group' => 'auth',
    ]);

});
