<?php


use App\Http\Controllers\IncompatibleMedicationController;
use App\Http\Controllers\OrderController;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Mtc\Modules\Members\Http\Controllers\AuthController;

/** @var Router $router */


$router->group([
    'middleware' => 'auth',
], function (Router $router) {
    $router->resource('/shop/admin/products/{item}/incompatible-medications', IncompatibleMedicationController::class);
    $router->get('/shop/admin/orders/{order}/confirm-id-check', [ OrderController::class, 'confirmIDCheck']);

    Route::get('laravel-logs', [\Rap2hpoutre\LaravelLogViewer\LogViewerController::class, 'index']);
});

Route::group([
    'middleware' => ['web'],
], function () {
    Route::get('register-express', [AuthController::class, 'registerExpress'])
        ->name('members-register-express');
    Route::post('register-express', [AuthController::class, 'registerExpressAction'])
        ->name('members-register-express-action');

    // Component Registry (requires admin authentication)
    Route::get('component', [
        'as' => 'component-registry',
        'uses' => 'App\Http\Controllers\ComponentRegistryController@index'
    ]);

    Route::get('component/preview/{path}', [
        'as' => 'component-preview',
        'uses' => 'App\Http\Controllers\ComponentPreviewController@show'
    ])->where('path', '.*');
});




Route::get('modules/Members/admin/manage_member.php?id={member_id}', [
    'as' => 'admin-manage-member',
]);

Route::get('admin/shop/category/{category_id}/display-tags', [
    'as' => 'admin-shop-category-display-tags',
    'uses' => 'Mtc\Shop\Http\Controllers\Admin\DisplayTagsController@get_category_data',
    'group' => 'auth',
]);

Route::post('admin/shop/category/{category_id}/display-tags/save', [
    'as' => 'admin-shop-category-display-tags-save',
    'uses' => 'Mtc\Shop\Http\Controllers\Admin\DisplayTagsController@save_category_data',
    'group' => 'auth',
]);

Route::get('admin/shop/product/{product_id}/display-tags', [
    'as' => 'admin-shop-product-display-tags',
    'uses' => 'Mtc\Shop\Http\Controllers\Admin\DisplayTagsController@get_product_data',
    'group' => 'auth',
]);

Route::post('admin/shop/product/{product_id}/display-tags/save', [
    'as' => 'admin-shop-product-display-tags-save',
    'uses' => 'Mtc\Shop\Http\Controllers\Admin\DisplayTagsController@save_product_data',
    'group' => 'auth',
]);


Route::get('admin/assetgallery/icons/manage', [
    'as' => 'admin-assetgallery-icons-manage',
    'uses' => 'Mtc\Cms\Http\Controllers\Admin\AssetGalleryController@icons_manage',
    //'group' => 'auth',
]);

Route::get('admin/assetgallery/icons/edit/{icon_id}', [
    'as' => 'admin-assetgallery-icons-edit',
    'uses' => 'Mtc\Cms\Http\Controllers\Admin\AssetGalleryController@icon_edit',
    'group' => 'auth',
]);

Route::any('admin/assetgallery/icons/{icon_id?}', [
    'as' => 'admin-assetgallery-icons-upsert',
    'uses' => 'Mtc\Cms\Http\Controllers\Admin\AssetGalleryController@icon_upsert',
    'group' => 'auth',
]);

Route::get('admin/assetgallery/icons/{icon_id}/delete', [
    'as' => 'admin-assetgallery-icons-delete',
    'uses' => 'Mtc\Cms\Http\Controllers\Admin\AssetGalleryController@icon_delete',
    'group' => 'auth',
]);



/* FRONT END */

Route::any('sitemap.xml', [
    'as' => 'sitemap-xml',
    'uses' => 'App\Http\Controllers\SitemapController@index'
]);

Route::any('online-doctor/{category_slug}', [
    'as' => 'online-doctor',
    'uses' => 'App\Http\Controllers\CategoryController@index'
]);

Route::any('api/category/products/{category_id}', [
    'as' => 'category-products-api',
    'uses' => 'App\Http\Controllers\CategoryController@category_products_json'
]);

Route::any('subscription/create/choice', [
    'as' => 'subscription-create-choice',
    'uses' => 'App\Http\Controllers\ShopController@subscription_create_choice'
]);

Route::any('shop/checkout/basket.php', [
    'as' => 'shop-checkout-basket',
]);

Route::any('shop/addtobasket.php', [
    'as' => 'shop-addtobasket',
]);

Route::any('test/shop/basket/add-multiple', [
    'as' => 'test-shop-basket-add-multiple',
    'uses' => 'App\Http\Controllers\ShopController@test_add_to_basket_multiple',
]);

Route::post('shop/basket/add-multiple', [
    'as' => 'shop-basket-add-multiple',
    'uses' => 'App\Http\Controllers\ShopController@add_to_basket_multiple',
]);

Route::any('shop/basket/allowed-products', [
    'as' => 'shop-basket-allowed-products',
    'uses' => 'App\Http\Controllers\ShopController@get_basket_allowed_products',
]);

Route::any('shop/select-variation/{shop_item_id}', [
    'as' => 'shop-select-variation',
    'uses' => 'App\Http\Controllers\ShopController@staggered_checkout__select_variation'
]);

Route::any('shop/select-strength/{shop_item_id}', [
    'as' => 'shop-select-strength',
    'uses' => 'App\Http\Controllers\ShopController@staggered_checkout__select_strength'
]);

Route::any('shop/select-packsize/{shop_item_id}', [
    'as' => 'shop-select-packsize',
    'uses' => 'App\Http\Controllers\ShopController@staggered_checkout__select_packsize'
]);

Route::any('shop/select-subscription/{shop_item_id}/{shop_item_size_id?}', [
    'as' => 'shop-select-subscription',
    'uses' => 'App\Http\Controllers\ShopController@staggered_checkout__select_subscription'
]);

Route::any('shop/request-subscription/{shop_item_id}/{shop_item_size_id?}', [
    'as' => 'shop-request-subscription',
    'uses' => 'App\Http\Controllers\ShopController@staggered_checkout__request_subscription'
]);

Route::any('shop/remove-subscription/{shop_item_id}/{shop_item_size_id?}', [
    'as' => 'shop-remove-subscription',
    'uses' => 'App\Http\Controllers\ShopController@staggered_checkout__remove_subscription'
]);


/* Assessment forms */

Route::get('assessment/{form_id}', [
    'as' => 'assessment-form',
    'uses' => 'App\Http\Controllers\AssessmentDisplayController@index'
]);

Route::post('assessment/{form_id}', [
    'as' => 'assessment-submit',
    'uses' => 'App\Http\Controllers\AssessmentCheckoutController@save'
]);
