<?php
/* * ***********************************************************************************************************************************
 *                                                      INITIALISE
 * *********************************************************************************************************************************** */

$path = '../../';
require($path . 'core/includes/header.inc.php');

use Illuminate\Support\Facades\DB;
use Mtc\Core\Models\CountryState;

$order_id = 0;
if(!empty($_REQUEST['order_id']) && is_numeric($_REQUEST['order_id'])) {
    $order_id = $_REQUEST['order_id'];
} else {
    $order = \Mtc\Shop\Order::query()
        ->orderBy(DB::raw('RAND()'))
        ->first();
    if (!empty($order)) {
        $order_id = $order->id;
    }
}

$header_style = "font-family:Arial, Helvetica, sans-serif;text-align:center;margin:40px 0 0;font-size:30px;";
$hr_style = "border: 1px solid #a7a7a7;";

/* * ***********************************************************************************************************************************
 *                                                      OUTPUT
 * *********************************************************************************************************************************** */

$order = Order::getById($order_id);

$preorder = false;

if(is_object($order)) {
    $line_items = $order->getLineItems();
} else {
	?>
	<div style="text-align:center;max-width:980px;padding: 8px 35px 8px 14px;margin: 20px auto;color: #C09853;text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);background-color: #FCF8E3;border: 1px solid #FBEED5;border-radius: 2px;">
		Order number does not exist, please add ?order_id=VALID_ORDER_ID to the url
	</div>
<?php
	exit();
}
?>

<h1 style="<?= $header_style ?>font-size:45px;margin-bottom:40px;">Email Templates</h1>

<?php

$options = [
    'order' => $order, // order details
    'line_items' => $line_items, // Order items with additional up to date information pulled from the item class
    'order_subtotal' => $order->getSubtotalCost(),
    'order_total' => $order->getTotalCost(),
    'vat_cost' => $order->getVatCost(), // Total VAT cost of the order
    'order_date' => $order->getOrderDate('Y-m-d H:i:s'), // order date sent in full... twig can re-render into any date format from here
    'delivery_cost' => $order->getDelivery()->cost, // Delivery Cost
    'delivery_name' => $order->getDelivery()->name, // Delivery Name
    'order_status_text' => '', // Order status text as defined in admin under shop/order status text
    'countries' => $countries,
    'state_list' => CountryState::getCountryStateList()
];

$order_status_text = $order->getOrderStatusText(0);
$options['order_status_text'] = $order_status_text;

$filepath = 'emails/shop/order_email.twig';
echo "<hr style='". $hr_style ."'/><h1 style='" . $header_style . "'>Order Email Notification</h1>";
echo "<strong><pre style='text-align:center;margin-bottom:30px;'>" . $filepath . "</pre></strong>";
echo $twig->render($filepath, $options);

$order_status_text = $order->getOrderStatusText(4);
$options['order_status_text'] = $order_status_text;

$filepath = 'emails/shop/shipment_email.twig';
echo "<hr style='". $hr_style ."'/><h1 style='" . $header_style . "'>Shipment Notification</h1>";
echo "<strong><pre style='text-align:center;margin-bottom:30px;'>" . $filepath . "</pre></strong>";
echo $twig->render($filepath, $options);

$filepath = 'emails/shop/refund.twig';
echo "<hr style='". $hr_style ."'/><h1 style='" . $header_style . "'>Refund Notification</h1>";
echo "<strong><pre style='text-align:center;margin-bottom:30px;'>" . $filepath . "</pre></strong>";
echo $twig->render($filepath, $options);

$filepath = 'emails/shop/partial_refund.twig';
echo "<hr style='". $hr_style ."'/><h1 style='" . $header_style . "'>Partial Refund Notification</h1>";
echo "<strong><pre style='text-align:center;margin-bottom:30px;'>" . $filepath . "</pre></strong>";
echo $twig->render($filepath, $options);

$options['subject'] = 'Sample Message';
$options['html'] = '<p>This is a sample message to show a customer message.</p><p>This is a sample paragraph to show a paragraph being replaced with the correct styles.</p>';

$filepath = 'emails/shop/contact_email.twig';
echo "<hr style='". $hr_style ."'/><h1 style='" . $header_style . "'>Customer Contact Notification</h1>";
echo "<strong><pre style='text-align:center;margin-bottom:30px;'>" . $filepath . "</pre></strong>";
echo $twig->render($filepath, $options);

$filepath = 'emails/shop/pre_payment.twig';
echo "<hr style='". $hr_style ."'/><h1 style='" . $header_style . "'>Pre Order Email Notification</h1>";
echo "<strong><pre style='text-align:center;margin-bottom:30px;'>" . $filepath . "</pre></strong>";
echo $twig->render($filepath, $options);
