<?php

use Mtc\Shop\Ingredient;
ini_set('max_input_vars', 10000);
$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Manage Ingredients';

$errors = [];

if ($_REQUEST['action'] === 'delete' && is_numeric($_REQUEST['delete_id'])) {
    $ingredient = (new Ingredient)->find($_REQUEST['delete_id']);
    // Delete the items
    $ingredient->items()->detach();
    // Delete the site
    $ingredient->delete();
    header('location: manage.ingredients.php');
    exit;
}

if (filter_input(INPUT_POST, 'action') === 'update_limits') {
    if (!empty($_REQUEST['limits'])) {
        foreach ($_REQUEST['limits'] as $ingredient_id => $limits) {
            $limits['limit_once'] = $limits['limit_once'] ?? 0;
            (new Ingredient())
                ->find($ingredient_id)
                ->fill($limits)
                ->save();
        }
    }
}

$ingredients = Ingredient::query()->orderBy('name')->get();

require_once $path . 'core/admin/templates/adminheader.html.php';

?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>

    <li class="end">Ingredients</li>
</ul>

<h1>Ingredients</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) { showerrors($errors); }

if (count($ingredients) > 0) {
    $header = '<tr>
                <th nowrap="">Ingredient</th>
                <th>Limit type</th>
                <th>Period (days)</th>
                <th>Per period</th>
                <th>Per Order</th>
                <th>Limit Once</th>
                <th>Message</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>';
    ?>
    <form method="post">
        <input type="submit" value="Update Limits"/>
        <table class="manage-items">
            <tbody class="tabular">
            <?php
            $i = 0;
            foreach ($ingredients as $ingredient) {
                if ($i % 21 === 0) {
                    echo $header;
                }
                ?>
                <tr id="rorder-<?= $ingredient->id;?>">
                    <td><?= clean_page($ingredient->name); ?></td>
                    <td><?= clean_page($ingredient->limit_type); ?></td>
                    <td>
                        <input type="text"
                               name="limits[<?= $ingredient->id; ?>][limit_period]"
                               class="short"
                               value="<?= clean_page($ingredient->limit_period); ?>"
                        />
                    </td>
                    <td>
                        <input type="text"
                               name="limits[<?= $ingredient->id; ?>][limit_amount]"
                               class="short"
                               value="<?= clean_page($ingredient->limit_amount); ?>"
                        />
                    </td>
                    <td>
                        <input type="text"
                               name="limits[<?= $ingredient->id; ?>][limit_order]"
                               class="short"
                               value="<?= clean_page($ingredient->limit_order); ?>"
                        />
                    </td>
                    <td>
                        <input type="checkbox"
                               name="limits[<?= $ingredient->id; ?>][limit_once]"
                               value="1"
                                <?= $ingredient->limit_once ? 'checked' : ''; ?>
                        />
                    </td>
                    <td><?= $ingredient->message; ?></td>
                    <td class="center"><a href="manage.ingredient.php?id=<?=$ingredient->id; ?>" class="edit" ><i class="fa fa-pencil"></i></a></td>
                    <td class="center"><a href="manage.ingredients.php?action=delete&delete_id=<?=$ingredient->id; ?>" class="alert picto error" title="Are you sure you want to delete the Ingredient?"><i class="fa fa-times-circle"></i></a></td>
                </tr>
                <?php
                ++$i;
            }
            ?>
            </tbody>
        </table>
        <input type="hidden" name="action" value="update_limits">
        <input type="submit" value="Update Limits"/>
    </form>
    <?php
} else {
    ?>
    <p>No Ingredients have been created</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
