<?php

use Mtc\Shop\Brand;
use Mtc\Shop\Order\Shipment;

$path = '../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Order Invoice';

$order = Order::getById($_REQUEST['id']);

$display_form = true;

require_once $path . 'core/includes/adminheader.full.php';

?>
<h1 style="font-size:16px;">Commercial Invoice</h1>

<?php
if (sizeof($errors)) {
    ?>
    <p class="error">
        <?php
        foreach ($errors as $error) {
            echo "$error<br/>";
        }
        ?>
    </p>
    <?php
}
?>

<style type="text/css">
<!--
body {
    font-family:arial, sans-serif;
    font-size:12px;
    margin: 0;
    padding: 0;
}

#invoice td {
    color:#000;
}

textarea {
    border:0;
    width:100%;
    height:100px;
    font-family:arial;
    color:#000;
    overflow:hidden;
}

textarea:hover, textarea:active {
    background:#eee;
}

input.text {
    border:0;
    width:90%;
}

input.text:hover, input.text:active {
    background:#eee;
}
-->
</style>

<p class="hide-print">The below invoice has been pre-populated with the available order information. Edit any fields that requires ammendments then click print to print off the invoice.</p>

<form method="post" id="invoice">
    <table cellpadding="3" cellspacing="0" border="1" width="98%">
        <tr>
            <td colspan="4">Date of Export: <input type="text" name="date_of_export" class="text" value="<?= date("d M Y");?>" style="width:100px;"/></td>
            <td colspan="4">Export References (i.e. order no., invoice no., etc): <input type="text" name="export_references" class="text" value="<?= $order->getId()?>" style="width:50px;"/></td>
        </tr>
        <tr>
            <td colspan="4">
                Shipper/Exporter (complete name and address):<br/>
                <textarea name="exporter">NIRO�S HASH CLOTHING LTD  (TOGGED)
2 CUMBERGATE
PETERBOROUGH
CAMBS
UK
PE1 1YR</textarea>
            </td>
            <td colspan="4">
                <?php
                    ob_start();
                    include($path.'shop/templates/basket.billing.php');
                    $address = ob_get_clean();
                    echo str_replace('<br/>', "", $address);
                ?>
            </td>
        </tr>
        <tr>
            <td colspan="4">Country of export: United Kingdom</td>
            <td colspan="4" rowspan="3" valign="top">
                Importer - if other than recipient (complete name and address):
                <?php
                    ob_start();
                    include($path.'shop/templates/basket.billing.php');
                    $address = ob_get_clean();
                    echo str_replace('<br/>', "", $address);
                ?>
            </td>
        </tr>
        <tr>
            <td colspan="4">Country of manufacture: <input type="text" class="text"/></td>
        </tr>
        <tr>
            <td colspan="4">Country of ultimate destination: <?= $countries[$order->address['billing']['country']];?></td>
        </tr>
        <tr>
            <td colspan="4">
                Federal Express International Air Waybill Number:
                <input type="text" class="text"/>
            </td>
            <td colspan="4">
                Currency:
                <?php
                if ($order->address['billing']['country'] == 'US') {
                    echo '$ US DOLLAR';
                } else {
                    echo '&pound; BRITISH POUND';
                }
                ?>
            </td>
        </tr>
        <tr>
            <td>Quantity</td>
            <td width="50">Gender</td>
            <td>Fabric</td>
            <td width="130">Garment</td>
            <td width="50">Knitted/Woven</td>
            <td width="130">Manufacturer(s)</td>
            <td width="50">Unit value</td>
            <td width="50">Total Value</td>
        </tr>
        <?php
        $previous_brands = array();
        if (sizeof($order->getItems())) {
            foreach ($basket->get_items() as $id_item => $i) {
                $item = new Item();
                $item->Get_Item($i['item_id']);
                ?>
                <tr>
                    <td><?= $i['quantity'];?></td>
                    <td width="50">
                        <?php
//						if ($item->male == 1) {
//							echo 'Mens';
//						}
//						elseif ($item->female == 1) {
//							echo 'Womens';
//						}
                        ?>
                        <input type="text" class="text"/>&nbsp;
                    </td>
                    <td><textarea></textarea>&nbsp;</td>
                    <td><textarea></textarea>&nbsp;</td>
                    <td width="50"><input type="text" class="text"/>&nbsp;</td>
                    <td>
                        <?php
                        if (!in_array($item->brand, $previous_brands)) {
                            $previous_brands[] = $item->brand;
                            $brand = Brand::query()
                                ->find($item->brand);
                            if (!empty($brand)) {
                                $data = $brand->toArray();
                                echo $data['address_1'] != '' ? $data['address_1'] . '<br/>' : '';
                                echo $data['address_2'] != '' ? $data['address_2'] . '<br/>' : '';
                                echo $data['address_3'] != '' ? $data['address_3'] . '<br/>' : '';
                                echo $data['city'] != '' ? $data['city'] . '<br/>' : '';
                                echo $data['country'] != '' ? $data['country'] . '<br/>' : '';
                                echo $data['postcode'] != '' ? $data['postcode'] . '<br/>' : '';
                            }
                        }
                        ?>
                    </td>
                    <td><input type="text" class="text"/>&nbsp;</td>
                    <td><input type="text" class="text"/>&nbsp;</td>
                </tr>
                <?php
                $t_value+= $i['item_price'] * $i['quantity'];
            }
        } else {
            ?>
            <tr>
                <td colspan="8">There are no items on this order</td>
            </tr>
            <?php
        }
        ?>
        <tr>
            <td>&nbsp;</td>
            <td>Total No. of Pkgs</td>
            <td colspan="3"><input type="text" class="text"/></td>
            <td>Total Weight KG</td>
            <td><input type="text" class="text"/></td>
            <td>Total<br/> Invoice<br/> Value<input type="text" class="text" value="<?php //$t_value;?>"/></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td colspan="3"><span style="color:#000099;font-size:14px;">Personal Use - Not for Re-Sale</span></td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td colspan="6">
                <table>
                    <tr>
                        <td colspan="2">&nbsp;</td>
                        I declare all the information contained in this invoice to be true and correct, all items are for<br/>
                        <span style="color:#000099;font-size:14px;">Personal Use - Not for Re-Sale</span><br/>
                    </tr>
                    <tr>
                        <td>
                        Signature of shipper/exporter (type name and title and sign)<br/>
                        <br/>
                        <br/>
                        ________________________________________________
                        </td>
                        <td style="padding-left:50px;">
                        Date<br/>
                        <br/>
                        <br/>
                        ________________________
                        </td>
                    </tr>
                </table>
            </td>
            <td colspan="2">
            <input type="checkbox" style="float:left;margin-top:-1px;"> FOB<br class="clear"/>
            <br/>
            <input type="checkbox" style="float:left;margin-top:0px;""> C&amp;F<br class="clear"/>
            <br/>
            <input type="checkbox" style="float:left;margin-top:0px;"> CIF
            </td>
        </tr>
        <tr>
            <td colspan="8">
            TRACKING NUMBER:
            <?php
            Shipment::query()
                ->where('order_id', $order->getId())
                ->get()
                ->each(function ($shipment) {
                    echo $shipment->tracking_no;
                });
            ?>
            </td>
        </tr>
    </table>
    <br/>
    <div class="save-button">Click here to print <input type="button" value="Print Invoice" onclick="javascript:window.print();"/></div>
    <br/>
    <br/>
</form>

<?php
require_once $path . 'core/includes/adminfooter.full.php';
