<?php

use Illuminate\Database\Eloquent\Builder;
use Mtc\Shop\Assessment\Form;
use Mtc\Shop\Brand;
use Mtc\Shop\Category;
use Mtc\Shop\Vat;
use MtcPharmacy\Multisite\Classes\MultisiteManager;
use MtcPharmacy\Multisite\Classes\MultisiteSite;


$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'epos_id' => null,
    'name' => null,
    'catid' => null,
    'orderbyfield' => null,
    'orderbydir' => null,
    'page' => null,
    'product_type' => null,
    'vat_rate' => null,
    'published' => null,
    'brandid' => null,
    'lowstock' => null,
    'sex' => null,
    'url_alias' => null,
    'add_products_import' => null,
]);

$page_meta['title'] = 'Manage Products';

$errors = [];

//array of GET or POST keys that the page uses to remember the view state
$view_state_keys = [
    'name',
    'epos_id',
    'sex',
    'catid',
    'brandid',
    'orderbydir',
    'orderbyfield',
    'page',
    'published',
];

if (filter_input(INPUT_POST, 'action') === 'import_products') {
    $response = \Mtc\Shop\Item::importProducts((bool)$_REQUEST['add_products_import']);
    $errors = $response['errors'];
    if (empty($errors)) {
        $query_params = $_GET;
        $query_params['success'] = 'import_successful';
        $_SESSION['flash_messages']['success'] = $response['success'];
        header('location: manage.products.php?' . http_build_query($query_params));
        exit;
    }
}

if (filter_input(INPUT_POST, 'action') === 'export_products__multisite') {
    \Mtc\Shop\Item::exportProducts($_REQUEST);
}

if (filter_input(INPUT_POST, 'action') === 'export_products') {
    \Mtc\Shop\Item::exportProducts($_REQUEST);
}

if (filter_input(INPUT_POST, 'action') === 'export_google_feed') {
    \Mtc\Shop\Item::exportGoogleFeedProducts($_REQUEST);
}

\Mtc\Shop\Item::query()
    ->whereIn('product_type', ['prescription', 'private_prescription'])
    ->where('created_at', '<', Carbon\Carbon::now()->subMonth(1)->format('Y-m-d H:i:s'))
    ->delete();


if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'update') {
    $items = (array) $_REQUEST['items'];
    $hide = (array) $_REQUEST['hide'];

    foreach ($items as $item) {
        \Mtc\Shop\Item::query()
            ->where('id', $item)
            ->update([
                'hidden' => 1,
            ]);
    }

    foreach ($hide as $item_id) {
        \Mtc\Shop\Item::query()
            ->where('id', $item_id)
            ->update([
                'hidden' => 0,
            ]);
    }

    if (!empty($_POST['multi_delete'])) {
        foreach ($_POST['multi_delete'] as $k => $delete_id) {
            (new Item($delete_id))->delete();
        }
    }
    header('Refresh: 0');
    exit;
}

if (!empty($_REQUEST['action']) && $_REQUEST['action'] == 'delete' && is_numeric($_REQUEST['delete_id'])) {
    if ((new Item($_REQUEST['delete_id']))->delete()) {
        header('Location: manage.products.php?' . getViewStateQueryString($_REQUEST, $view_state_keys));
        exit;
    }
}

$brands = Brand::query()
    ->orderBy('order')
    ->orderBy('name')
    ->get()
    ->toArray();

$vat_rates = Vat::query()
    ->orderBy('name')
    ->get()
    ->mapWithKeys(function ($item) {
        return [$item->id => $item->name];
    })
    ->toArray();


$vat_rates = Form::query()
    ->orderBy('name')
    ->get()
    ->mapWithKeys(function ($item) {
        return [$item->id => $item->name];
    })
    ->toArray();

$append = http_build_query($_REQUEST);

$query = \Mtc\Shop\Item::query()
    ->select([
        'items.id',
        'items.name',
        'items.epos_code',
    ])
    ->where('items.id', '>', 0)
    ->where('items.deleted', 0)
    ->where('items.product_type', '!=', \Mtc\Shop\Item::TYPE_PRIVATE_PRESCRIPTION)
    ->where('items.product_type', '!=', \Mtc\Shop\Item::TYPE_CONSULTATION)
    ->when(!empty($_REQUEST['epos_id']), function (Builder $query) {
        $query->where('items.epos_code', 'LIKE', '%' . $_REQUEST['epos_id'] . '%');
    })
    ->when(!empty($_REQUEST['brandid']), function (Builder $query) {
        $query->leftJoin('items_brands', 'items.id', '=', 'items_brands.item_id')
            ->where('items_brands.brand_id', '=', $_REQUEST['brandid']);
    })
    ->when(!empty($_REQUEST['catid']), function (Builder $query) {
        $query->leftJoin('items_categories', 'items.id', '=', 'items_categories.item_id')
            ->addSelect('items_categories.id AS order_id')
            ->addSelect('items_categories.order AS order')
            ->where('items_categories.cat_id', '=', $_REQUEST['catid']);
    })
    ->when(!empty($_REQUEST['name']), function (Builder $query) {
        $query->where('items.name', 'LIKE', '%' . $_REQUEST['name'] . '%');
    })
    ->when(!empty($_REQUEST['product_type']), function (Builder $query) {
        $query->where('items.product_type', '=', $_REQUEST['product_type']);
    })
    ->when(!empty($_REQUEST['vat_rate']), function (Builder $query) {
        $query->where('items.vat_rate', '=', $_REQUEST['vat_rate']);
    })
    ->when(!empty($_REQUEST['lowstock']), function (Builder $query) {
        $query->where('items.stock', '<', 2);
    })
    ->when(!empty($_REQUEST['published']), function (Builder $query) {
        $query->where('items.hidden', '=', ($_REQUEST['published'] === 'yes' ? 0 : 1));
    })
    ->groupBy('items.id');

if (!empty($_REQUEST['catid'])) {
    $orderbyfield = 'order';
} else {
    $orderbyfield = 'id';
}

if (!empty($_REQUEST['orderbyfield']) && !empty($_REQUEST['orderbydir'])) {
    $orderbyfield = str_replace('-', '.', $_REQUEST['orderbyfield']);
    $orderbydir = $_REQUEST['orderbydir'];
}

if (empty($_REQUEST['orderbydir']) || $_REQUEST['orderbydir'] == 'ASC') {
    $orderbydir = 'ASC';
    $orderbydiropp = 'DESC';
} else {
    $orderbydir = 'DESC';
    $orderbydiropp = 'ASC';
}

$query->orderBy($orderbyfield, $orderbydir);

$totalnumrows = $query->count();

if ($_REQUEST['page'] == '') {
    $_REQUEST['page'] = 1;
}

$rowsPerPage = 25;
$pageNum = $_REQUEST['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$items = $query->limit($rowsPerPage)
    ->offset($offset)
    ->get();
$pagestoshow = 10;

$is_sortable = !empty($_REQUEST['catid']);

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Manage Products</h1>

<?php
include __DIR__ . '/tabnav.php';

if (empty($errors) && isset($GLOBALS['flash_messages']) && !empty($GLOBALS['flash_messages']['success'])) {
    echo showmsg($GLOBALS['flash_messages']['success'], 'success', $path);
}
if (!empty($errors)) {
    echo showerrors($errors);
}
?>


<form action="manage.products.php" method="get" class="style">
    <fieldset
        <?php
        if ($_REQUEST['action'] == 'search') {
        ?>
            class="show"
        <?php
        }
        ?>
        >
        <h1><a class="show el">Search <i class="fa fa-caret-right"></i></a></h1>
        <div class="row">
            <p>Use * to match any character or sequence of characters in a search</p>
        </div>

        <div class="row">
            <label for="name">Name</label>
            <input type="text" name="name" id="name" value="<?= clean_page($_REQUEST['name']) ?>">
        </div>
        <div class="row">
            <label for="product_type">Product Type</label>
            <select name="product_type" id="product_type">
                <option value="">Any</option>
                <option value="general" <?= $_REQUEST['product_type'] === 'general' ? 'selected' : ''; ?>>General</option>
                <?php
                foreach (\Mtc\Shop\Item::$product_types as $type => $name) {
                    $selected = $type === $_REQUEST['product_type'] ? 'selected' : '';
                    echo "<option value='{$type}' {$selected}>{$name}</option>";
                }
                ?>
            </select>
        </div>

        <?php if (VAT_ENABLED === true) { ?>
            <div class="row">
                <label for="vat_rate">VAT Rate</label>
                <select name="vat_rate" id="vat_rate">
                    <option value="">Any</option>
                    <?php
                    foreach ($vat_rates as $rate_id => $rate_name) {
                        $selected = ($rate_id == $_REQUEST['vat_rate']) ? ' selected' : '';
                        echo '<option value="'.$rate_id.'"'.$selected.'>'.$rate_name.'</option>';
                    }
                    ?>
                </select>
            </div>
        <?php } ?>

        <?php
        if (ITEMS_CODE === true) {
        ?>
            <div class="row">
                <label for="epos_id">Code</label>
                <input type="text" name="epos_id" id="epos_id" value="<?= clean_page($_REQUEST['epos_id']) ?>">
            </div>
        <?php
        }

        if (CATEGORIES_MAX > 0) {
        ?>
            <div class="row">
                <label for="catid">Category</label>
                <select name="catid" id="catid">
                    <option value="">All</option>
                    <?= Category::renderList([
                        'template' => 'option',
                        'show_subs' => true,
                        'selected' => (!empty($_REQUEST['catid']) ? $_REQUEST['catid'] : 0),
                    ]) ;?>
                </select>
            </div>
        <?php
        }

        if (BRANDS_ENABLED === true) {
        ?>
            <div class="row">
                <label for="brandid">Brand</label>
                <select name="brandid" id="brandid">
                    <option value="">All</option>
                    <?php
                    foreach ($brands as $data) {
                        if ($_REQUEST['brandid'] == $data["id"]) {
                        ?>
                            <option value="<?= clean_page($data['id']) ?>" selected><?= clean_page($data['name']) ?></option>
                        <?php
                        } else {
                        ?>
                            <option value="<?= clean_page($data['id']) ?>"><?= clean_page($data['name']) ?></option>
                        <?php
                        }
                    }
                    ?>
                </select>
            </div>
        <?php
        }

        ?>
        <div class="row">
            <label for="lowstock">Low Stock</label>
            <input type="checkbox" name="lowstock" id="lowstock" <?= (!empty($_REQUEST['lowstock'])) ? "checked" : ''; ?>>
        </div>
        <div class="row">
            <label for="published">Published</label>
            <select name="published" id="published">
                <option value="">Any</option>
                <option value="yes" <?= $_REQUEST['published'] === 'yes' ? 'selected' : ''; ?>>Yes</option>
                <option value="no" <?= $_REQUEST['published'] === 'no' ? 'selected' : ''; ?>>No</option>
            </select>
        </div>

        <input type="hidden" name="action" value="search">

        <div class="row">
            <div class="search-button"><input type="submit" value="Search" class="BUTTON"/></div>
        </div>

    </fieldset>

</form>

<?php
if ($items->count() > 0) {

    if (empty($_REQUEST['catid'])) {
        require $path . 'core/admin/templates/pagination.php';
    }
    ?>
    <form action="" method="post">
        <table class="manage-items">
            <tr>
                <?php
                if ($is_sortable) {
                ?>
                    <th class="center">Order</th>
                <?php
                }

                if (ITEMS_CODE === true) {
                ?>
                    <th>
                        <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                                'orderbydir' => $orderbydiropp,
                                'orderbyfield' => 'items-epos_code',
                                'page' => 1
                            ]) ?>">
                            EPOS Code
                            <?php
                            if ($_REQUEST['orderbyfield'] != 'items-epos_code') {
                                $odorderbydir = 'DESC';
                            } else {
                                $odorderbydir = $orderbydir;
                            }
                            ?>
                            <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                        </a>
                    </th>
                <?php
                }
                ?>
                <th>
                    <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                            'orderbydir' => $orderbydiropp,
                            'orderbyfield' => 'items-name',
                            'page' => 1
                        ]) ?>">
                        Name
                        <?php
                        if ($_REQUEST['orderbyfield'] !== 'items-name') {
                            $odorderbydir = 'DESC';
                        } else {
                            $odorderbydir = $orderbydir;
                        }
                        ?>
                        <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                    </a>
                </th>
                <th>
                    <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                        'orderbydir' => $orderbydiropp,
                        'orderbyfield' => 'items-price',
                        'page' => 1
                    ])
                    ?>">
                        Price
                        <?php
                        if ($_REQUEST['orderbyfield'] != 'items-price') {
                            $odorderbydir = 'DESC';
                        } else {
                            $odorderbydir = $orderbydir;
                        }
                        ?>
                        <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                    </a>
                </th>
                <th>
                    <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                        'orderbydir' => $orderbydiropp,
                        'orderbyfield' => 'items-vat_rate',
                        'page' => 1
                    ])
                    ?>">
                        VAT Rate
                        <?php
                        if ($_REQUEST['orderbyfield'] != 'items-vat_rate') {
                            $odorderbydir = 'DESC';
                        } else {
                            $odorderbydir = $orderbydir;
                        }
                        ?>
                        <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                    </a>
                </th>
                <th>
                    <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                        'orderbydir' => $orderbydiropp,
                        'orderbyfield' => 'items-product_type',
                        'page' => 1
                    ])
                    ?>">
                        Product Type
                        <?php
                        if ($_REQUEST['orderbyfield'] != 'items-product_type') {
                            $odorderbydir = 'DESC';
                        } else {
                            $odorderbydir = $orderbydir;
                        }
                        ?>
                        <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                    </a>
                </th>
                <th>
                    <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                        'orderbydir' => $orderbydiropp,
                        'orderbyfield' => 'items-form_id',
                        'page' => 1
                    ])
                    ?>">
                        Assessment Form
                        <?php
                        if ($_REQUEST['orderbyfield'] != 'items-form_id') {
                            $odorderbydir = 'DESC';
                        } else {
                            $odorderbydir = $orderbydir;
                        }
                        ?>
                        <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                    </a>
                </th>

                <?php
                if (IMAGES_MAX > 0) {
                ?>
                    <th>Images</th>
                <?php
                }

                if (ITEMS_SIZES === true) {
                ?>
                    <th>Sizes</th>
                <?php
                }

                ?>
                <th>
                    <a href="<?= 'manage.products.php?' . modifyViewStateQueryString($_REQUEST, $view_state_keys, [
                        'orderbydir' => $orderbydiropp,
                        'orderbyfield' => 'items-stock',
                        'page' => 1
                    ])
                    ?>">
                        Stock
                        <?php
                        if ($_REQUEST['orderbyfield'] !== 'items-stock') {
                            $odorderbydir = 'DESC';
                        } else {
                            $odorderbydir = $orderbydir;
                        }
                        ?>
                        <img src="/admin/images/<?= ($odorderbydir == 'DESC') ? 'down.png' : 'up.png'; ?>" border="0" />
                    </a>
                </th>
                <th class="center">Published</th>
                <th class="center">Copy</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
                <th class="center">Bulk Delete</th>
            </tr>
            <tbody class="tabular <?= $is_sortable ? 'ui-sortable' : '' ?>">
                <tr>
                    <td colspan="<?= $is_sortable ? '14' : '12'; ?>">&nbsp;</td>
                    <td>
                        <label for="bulkDeleteItemsToggle">All</label> <input type="checkbox" value="" class="bulkDeleteItemsToggle" id="bulkDeleteItemsToggle" />
                    </td>
                </tr>
                <?php
                foreach ($items as $item) {
                    $data = $item->toArray();
                    $item = new Item();
                    $item->Get_Item($data['id']);
                    ?>
                    <tr id="rorder-<?= clean_page($data['order_id'] ?? '') ?>">
                        <?php
                        if ($is_sortable) {
                        ?>
                            <td class="center order">
                                <i class="fa fa-arrows"></i>
                            </td>
                        <?php
                        }
                        ?>
                        <?php
                        if (ITEMS_CODE === true) {
                        ?>
                            <td><?= $item->epos_id; ?></td>
                        <?php
                        }
                        ?>
                        <td>
                            <a href="item.php?id=<?= $data['id']; ?>"><?= clean_page($item->name); ?></a>
                        </td>
                        <td>
                            <?php
                            if ($item->sale_price > 0) {
                            ?>
                                <s><?= $item->price; ?></s>
                                <?= $item->sale_price; ?>
                            <?php
                            } else {
                            ?>
                                <?= $item->price; ?>
                            <?php
                            }
                            ?>
                        </td>

                        <td class="itemVatRateColumn" data-item_id="<?= $item->id; ?>">
                            <span class="itemVatRateText" id="itemVatRateText-<?= $item->id; ?>"><?= clean_page($item->vat_rate); ?></span>
                            <select class="itemVatRateInput hideme" id="itemVatRateInput-<?= $item->id; ?>" data-item_id="<?= $item->id; ?>">
                                <?php
                                foreach ($vat_rates as $rate_id => $rate_name) {
                                    $selected = ($rate_name == $item->vat_rate) ? ' selected' : null;
                                    echo '<option value="'.$rate_name.'"'.$selected.'>'.$rate_name.'</option>';
                                }
                                ?>
                            </select>
                        </td>

                        <td class="itemProductTypeColumn" data-item_id="<?= $item->id; ?>">
                            <span class="itemProductTypeText"
                                  id="itemProductTypeText-<?= $item->id; ?>"
                            >
                                <?= clean_page($item->product_type ?: 'general'); ?>
                            </span>
                            <select class="itemProductTypeInput hideme"
                                    id="itemProductTypeInput-<?= $item->id; ?>"
                                    data-item_id="<?= $item->id; ?>"
                            >
                                <option value="">general</option>
                                <?php
                                foreach (\Mtc\Shop\Item::$product_types as $type => $name) {
                                    $selected = ($type == $item->product_type) ? ' selected' : null;
                                    echo '<option value="'.$type.'"'.$selected.'>'.$name.'</option>';
                                }
                                ?>
                            </select>
                        </td>

                        <td class="itemAssessmentFormColumn" data-item_id="<?= $item->id; ?>">
                            <span class="itemAssessmentFormText" id="itemAssessmentFormText-<?= $item->id; ?>">
                                <?php $af = $item->eloquent()->findAssessmentForm() ?>
                                <?php if ($af): ?>
                                    <?= $item->form_id ? $af->name : "(({$af->name}))" ?>
                                <?php endif ?>
                            </span>
                            <select class="itemAssessmentFormInput hideme" id="itemAssessmentFormInput-<?= $item->id; ?>" data-item_id="<?= $item->id; ?>">
                                <?php
                                $assessmentForms = Form::query()
                                    ->orderBy('name')
                                    ->get()
                                    ->mapWithKeys(function ($form) {
                                        return [$form->id => $form->name];
                                    });
                                foreach ($assessmentForms as $form_id => $form_name) {
                                    $selected = ($form_id == $item->form_id) ? ' selected' : null;
                                    echo '<option value="'.$form_id.'"'.$selected.'>'.$form_name.'</option>';
                                }
                                ?>
                            </select>
                        </td>

                        <?php
                if (IMAGES_MAX > 0) {
                    if (sizeof($item->images) > 0) {
                        ?>
                        <td>
                            <a href="images.php?id=<?= clean_page($data['id']) ?>">
                                <img src="<?= $item->eloquent()->getImagePath('default', 'thumbs') ?>"
                                    alt="Images"
                                    style="border:0;"
                                />
                            </a>
                        </td>
                    <?php } else { ?>
                        <td>
                            <a href="images.php?id=<?= clean_page($data['id']) ?>">
                                <i class="fa fa-picture-o"></i>
                            </a>
                        </td>
                    <?php
                    }
                }
                ?>
                <?php
                if (ITEMS_SIZES === true) {
                    ?>
                    <td>
                        <a href="manage.sizes.php?id=<?= clean_page($data['id']) ?>">
                            <div class="relative">
                                <?php
                                if (!empty($item->sizes)) {
                                ?>
                                    <div class="sizeHover clearfix">

                                        <table>
                                            <tr>
                                                <th>Size</th>
                                                <th>Stock</th>
                                                <?php

                                                if (ITEMS_SIZES_PRICES === true) {
                                                    ?>
                                                    <th>Price</th>
                                                    <?php
                                                }
                                                ?>
                                            </tr>
                                            <?php
                                            foreach ($item->sizes as $size) {
                                            ?>
                                                <tr>
                                                    <td>
                                                        <?= clean_page($size['size']) ?>
                                                    </td>
                                                    <td>
                                                        <?= clean_page($size['stock']) ?>
                                                    </td>
                                                        <?php
                                                    if (ITEMS_SIZES_PRICES === true) {
                                                    ?>
                                                        <td><?= ($size['sale_price'] > 0) ? '<strike>' . clean_page($size['sale_price']) . '</strike>' : clean_page($size['price']); ?></td>
                                                    <?php
                                                    }
                                                    ?>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                        </table>

                                    </div>
                                <?php
                                }
                                ?>
                                <i class="fa fa-signal"></i>
                            </div>
                        </a>
                    </td>
                    <?php
                }


                ?>
                <td>
                    <?php
                    if ($item->stock >= 2) {
                    ?>
                        <span style="color:green">
                    <?php
                    } else {
                    ?>
                        <span style="color:red">
                    <?php
                    }
                    ?>
                        <?= clean_page($item->stock) ?>
                    </span>
                </td>
                <?php

                $mm = new MultisiteManager($item->eloquent());
                ?>
                <td class="center">
                    <?php if ($mm->isEntityInSingleSiteMode()): ?>
                        <label>All sites</label>
                        <input type="checkbox" name="hide[]" value="<?= clean_page($item->id) ?>" <?= $item->isHidden() ? '' : 'checked'; ?> />
                    <?php else: ?>
                        <?php foreach ($mm->getCustomEntityData() as $site_name => $custom_item): ?>
                            <label><?= $site_name ?></label>
                            <input type="checkbox" name="hide[]" value="<?= clean_page($custom_item->id) ?>" <?= $custom_item->isHidden() ? '' : 'checked'; ?> />
                            <input type="hidden" name="items[]" value="<?= clean_page($custom_item->id) ?>" />
                        <?php endforeach ?>
                    <?php endif ?>
                </td>
                <input type="hidden" name="items[]" value="<?= clean_page($item->id) ?>" />
                <td class="center">
                    <a href="item.php?id=<?= clean_page($data['id']) ?>&type=similar">
                        <i class="fa fa-copy"></i>
                    </a>
                </td>
                <td class="center">
                    <a href="item.php?id=<?= clean_page($data['id']) ?>" class="edit">
                        <i class="fa fa-pencil"></i>
                    </a>
                </td>
                <td class="center">
                    <a href="manage.products.php?<?= getViewStateQueryString($_REQUEST, $view_state_keys) ?>&action=delete&delete_id=<?= clean_page($data['id']) ?>"
                        class="alert error"
                        title="Are you sure you want to delete this product?"
                    >
                        <i class="fa fa-times-circle"></i>
                    </a>
                </td>
                        <td class="center">
                            <input type="checkbox" name="multi_delete[]" value="<?= clean_page($item->id) ?>" class="bulkDeleteItems" />
                        </td>
                </tr>
                <?php
            }
            ?>
            <tr>
                <td colspan="<?= $is_sortable ? '14' : '12'; ?>">&nbsp;</td>
                <td>
                    <label for="bulkDeleteItemsToggle">All</label> <input type="checkbox" value="" class="bulkDeleteItemsToggle" id="bulkDeleteItemsToggle" />
                </td>
            </tr>
            </tbody>
        </table>
            <p>
                <?php
                foreach ($_GET as $key => $value) {
                ?>
                    <input type="hidden" name="<?= clean_page($key) ?>" value="<?= clean_page($value) ?>">
                <?php
                }
                ?>
                <input type="hidden" name="action" value="update">
                <input type="submit" value="Update / Delete" class="BUTTON"/>
            </p>
        <input type="hidden" id="orderbytable" value="items_categories" />
        <input type="hidden" id="orderbyfield" value="order" />
    </form>
    <?php
    if (empty($_REQUEST['catid'])) {
        require $path . 'core/admin/templates/pagination.php';
    }
} else {
?>
    <p>There were no products found matching your search criteria</p>
<?php
}
?>

    <form method="post" class="style">
        <h2>Export <?php /*(multisite)*/?></h2>

        <div class="row">
            <input type="hidden" name="action" value="export_products__multisite"/>
            <?php /* foreach (MultisiteSite::all() as $site_data): ?>
                <button
                    type="submit"
                    name="multisite__site_id"
                    value="<?= $site_data->id ?>"
                    class="btn"
                >
                    <?= $site_data->name ?>
                </button>
            <?php endforeach */?>
            <button
                type="submit"
                name="multisite__site_id"
                value="all"
                class="btn"
            >
                Export
            </button>
        </div>
    </form>

    <form method="post" enctype="multipart/form-data" class="style" id="productImportForm">
        <h2>Import Products</h2>
        <fieldset>
            <div class="row">
                <label for="select_file">File selection</label>
                <input type="file" name="import" />
            </div>
            <div class="row">
                <label for="add_products_import">Create new products, if not matched</label>
                <input type="checkbox" name="add_products_import" id="add_products_import" value="1"/>
            </div>
            <div class="row">
                <input type="hidden" name="action" value="import_products"/>
                <input type="submit" value="Import"/>
            </div>
        </fieldset>
    </form>

    <form method="post" class="style">
        <h2>Export Google Feed</h2>
        <p>Click export below to export the above products as Google Merchant Center Feed</p>

        <div class="row">
            <input type="hidden" name="action" value="export_google_feed"/>

            <?php foreach (MultisiteSite::all() as $site_data): ?>
                <button
                    type="submit"
                    name="multisite__site_id"
                    value="<?= $site_data->id ?>"
                    class="btn"
                >
                    <?='Export' //$site_data->name ?>
                </button>
            <?php endforeach ?>
        </div>
    </form>
<?php

require_once $path . 'core/admin/templates/adminfooter.html.php';
