<?php

use Mtc\Shop\Report;
use Mtc\Shop\Category;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'report_type' => null,
    'start_date' => null,
    'end_date' => null,
    'category_id' => null,
    'vat_code' => null,
]);

$display_form = true;

$errors = [];

$page_meta['title'] = 'Sales Reports';

if ($_REQUEST['action'] === 'export') {
    $request = $_REQUEST;
    if (empty($request['start_date'])) {
        $errors[] = 'Please specify the start date';
    } else {
        $request['start_date'] = date_convert_dmy_to_db($request['start_date'], false);
    }
    if (empty($request['end_date'])) {
        $errors[] = 'Please specify the end date';
    } else {
        $request['end_date'] = date_convert_dmy_to_db($request['end_date'], false);
    }
    if (!empty($request['start_date']) && !empty($request['end_date']) && strtotime($request['start_date']) > strtotime($request['end_date'])) {
        $errors[] = 'End date must be larger than start date';
    }
    if (empty($request['report_type'])) {
        $errors[] = 'Please specify the report type';
    }
    if (empty($errors)) {
        $params = [
            'start_date' => $request['start_date'],
            'end_date' => $request['end_date'],
            'category_id' => $request['category_id'],
            'vat_code' => $request['vat_code'],
        ];
        Report::runReport($request['report_type'], $params);
        exit;
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="index.php">Sales Reports</a> /</li>
        <li class="end"><?= clean_page($page_meta['title']) ?></li>
    </ul>

    <h1>Sales Reports</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) {
    showerrors($errors);
}
?>

    <form action="" method="post" class="style">
        <fieldset class="show">
            <h1><a class="show el">Sales Reports <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="report_type">Report type</label>

                <select name="report_type" id="report_type">
                    <?php
                    foreach (Report::$types as $report_type => $report_details) {
                        $selected = $report_type === $_REQUEST['report_type'] ? 'selected' : '';
                        echo "<option value='{$report_type}' {$selected}>{$report_details['name']}</option>";
                    }
                    ?>
                </select>
            </div>

<?php /*

            <div class="row">
                <label for="vat_code">VAT code</label>
                <select name="vat_code" id="vat_code">
                    <option value="">All</option>
                    <?php
                    foreach (\Mtc\Shop\Item::$vat_codes as $vat_code => $vat_rate) {
                        $selected = $vat_code === $_REQUEST['vat_code'] ? 'selected' : '';
                        echo "<option value='{$vat_code}' {$selected}>{$vat_code} - {$vat_rate}</option>";
                    }
                    ?>
                </select>
            </div>

 */ ?>

            <div class="row">
                <label for="start-date">Date From</label>
                <input type="text"
                       class="datepicker short"
                       name="start_date"
                       id="start-date"
                       placeholder="DD/MM/YYYY"
                       autocomplete="off"
                       value="<?= clean_page($_REQUEST['start_date']); ?>"/>
            </div>

            <div class="row">
                <label for="end-date">Date To</label>
                <input type="text"
                       class="datepicker short"
                       name="end_date"
                       id="end-date"
                       placeholder="DD/MM/YYYY"
                       autocomplete="off"
                       value="<?= clean_page($_REQUEST['end_date']); ?>"/>
            </div>

<?php /*

            <div class="row">
                <label for="category_id">Category</label>
                <select name="category_id" id="catid">
                    <option value="">All</option>
                    <?= Category::renderList([
                        'template' => 'option',
                        'show_subs' => true,
                        'selected' => (!empty($_REQUEST['catid']) ? $_REQUEST['catid'] : 0),
                    ]) ;?>
                </select>
            </div>

 */ ?>

        </fieldset>
        <fieldset>
            <div class="save-button">
                <input type="hidden" name="action" value="export"/>
                <input type="submit" value="Export CSV"/>
            </div>
        </fieldset>
    </form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
