<?php
namespace Mtc\Shop\Category;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Category;
use Mtc\Shop\Item\Size;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class RestrictedZone extends Model
{
    protected $table = 'category_restricted_zones';

    protected $fillable = [
        'country_code',
        'country_name',
        'zone',
        'disable',
    ];

    /**
     * Define the relationship to categories
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function categories()
    {
        return $this->belongsTo(Category::class);
    }

}
